/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.util.Enumeration;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import org.jboss.logging.Logger;
import org.jboss.mq.MessagePool;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpySession;

public class SpyMessageProducer
implements MessageProducer {
    static Logger log = Logger.getLogger(SpyMessageProducer.class);
    static boolean trace = log.isTraceEnabled();
    protected SpySession session;
    protected Destination destination;
    protected int defaultDeliveryMode = 2;
    protected int defaultPriority = 4;
    protected long defaultTTL = 0L;
    private SynchronizedBoolean closed = new SynchronizedBoolean(false);
    private boolean disableMessageID = false;
    private boolean disableTS = false;

    SpyMessageProducer(SpySession session, Destination destination) {
        trace = log.isTraceEnabled();
        this.session = session;
        this.destination = destination;
        try {
            if (destination instanceof TemporaryQueue || destination instanceof TemporaryTopic) {
                this.setDeliveryMode(1);
            } else {
                this.setDeliveryMode(2);
            }
        }
        catch (JMSException ignored) {
            log.debug("Ignored error during setDeliveryMode", ignored);
        }
        if (trace) {
            log.trace("New message producer " + this);
        }
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.checkClosed();
        this.disableMessageID = value;
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.checkClosed();
        this.disableTS = value;
    }

    public void setDeliveryMode(int deli) throws JMSException {
        this.checkClosed();
        if (deli != 1 && deli != 2) {
            throw new JMSException("Bad DeliveryMode value");
        }
        this.defaultDeliveryMode = deli;
    }

    public void setPriority(int pri) throws JMSException {
        this.checkClosed();
        if (pri < 0 || pri > 9) {
            throw new JMSException("Bad priority value");
        }
        this.defaultPriority = pri;
    }

    public void setTimeToLive(int timeToLive) throws JMSException {
        this.checkClosed();
        if (timeToLive < 0) {
            throw new JMSException("Bad TimeToLive value");
        }
        this.defaultTTL = timeToLive;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.checkClosed();
        if (timeToLive < 0L) {
            throw new JMSException("Bad TimeToLive value");
        }
        this.defaultTTL = timeToLive;
    }

    public boolean getDisableMessageID() throws JMSException {
        this.checkClosed();
        return this.disableMessageID;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        this.checkClosed();
        return this.disableTS;
    }

    public int getDeliveryMode() throws JMSException {
        this.checkClosed();
        return this.defaultDeliveryMode;
    }

    public int getPriority() throws JMSException {
        this.checkClosed();
        return this.defaultPriority;
    }

    public long getTimeToLive() throws JMSException {
        this.checkClosed();
        return this.defaultTTL;
    }

    public void close() throws JMSException {
        if (this.closed.set(true)) {
            return;
        }
        this.session.removeProducer(this);
        if (trace) {
            log.trace("Closed " + this);
        }
    }

    public Destination getDestination() throws JMSException {
        this.checkClosed();
        return this.destination;
    }

    public void send(Message message) throws JMSException {
        if (this.destination == null) {
            throw new UnsupportedOperationException("Not constructed with identifyed destination. Usage of method not allowed");
        }
        this.send(this.destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTTL);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.send(destination, message, this.defaultDeliveryMode, this.defaultPriority, this.defaultTTL);
    }

    public void send(Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        if (this.destination == null) {
            throw new UnsupportedOperationException("Not constructed with identifyed destination. Usage of method not allowed");
        }
        this.send(this.destination, message, deliveryMode, priority, ttl);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long ttl) throws JMSException {
        this.checkClosed();
        if (this.destination != null && !this.destination.equals(destination)) {
            throw new UnsupportedOperationException("Sending to " + destination + " not allowed when producer created with " + this.destination);
        }
        if (destination == null || !(destination instanceof SpyDestination)) {
            throw new InvalidDestinationException("Destination is not an instance of SpyDestination " + destination);
        }
        SpyMessage sendMessage = !(message instanceof SpyMessage) ? this.encapsulateMessage(message) : (SpyMessage)message;
        sendMessage.setJMSDestination(destination);
        sendMessage.setJMSDeliveryMode(deliveryMode);
        long ts = System.currentTimeMillis();
        sendMessage.setJMSTimestamp(ts);
        if (ttl == 0L) {
            sendMessage.setJMSExpiration(0L);
        } else {
            sendMessage.setJMSExpiration(ttl + ts);
        }
        sendMessage.setJMSPriority(priority);
        String id = this.session.getNewMessageID();
        sendMessage.setJMSMessageID(id);
        if (message != sendMessage) {
            message.setJMSDestination(destination);
            message.setJMSDeliveryMode(deliveryMode);
            message.setJMSTimestamp(ts);
            if (ttl == 0L) {
                message.setJMSExpiration(0L);
            } else {
                message.setJMSExpiration(ttl + ts);
            }
            message.setJMSPriority(priority);
            message.setJMSMessageID(id);
        }
        if (trace) {
            log.trace("Sending message " + this + " \n" + sendMessage);
        }
        this.session.sendMessage(sendMessage);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("SpyMessageProducer@").append(System.identityHashCode(this));
        buffer.append("[ dest=").append(this.destination);
        if (this.defaultDeliveryMode == 2) {
            buffer.append(" delivery=").append("persist");
        } else {
            buffer.append(" delivery=").append("besteffort");
        }
        buffer.append(" priority=").append(this.defaultPriority);
        buffer.append(" ttl=").append(this.defaultTTL);
        buffer.append(" disableMessageID=").append(this.disableMessageID);
        buffer.append(" disableTS=").append(this.disableTS);
        buffer.append(" session=").append(this.session);
        buffer.append(']');
        return buffer.toString();
    }

    protected SpyMessage encapsulateMessage(Message message) throws JMSException {
        Message original;
        SpyMessage result;
        if (message instanceof BytesMessage) {
            result = MessagePool.getBytesMessage();
            original = (BytesMessage)message;
            original.reset();
            byte[] temp = new byte[1024];
            int bytes = original.readBytes(temp);
            while (bytes != -1) {
                ((BytesMessage)((Object)result)).writeBytes(temp, 0, bytes);
                bytes = original.readBytes(temp);
            }
        } else if (message instanceof MapMessage) {
            result = MessagePool.getMapMessage();
            original = (MapMessage)message;
            Enumeration en = original.getMapNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                try {
                    ((MapMessage)((Object)result)).setObject(key, original.getObject(key));
                }
                catch (JMSException ignored) {
                    if (!trace) continue;
                    log.trace("Unable to copy map entry " + key, ignored);
                }
            }
        } else if (message instanceof StreamMessage) {
            result = MessagePool.getStreamMessage();
            original = (StreamMessage)message;
            original.reset();
            try {
                while (true) {
                    ((StreamMessage)((Object)result)).writeObject(original.readObject());
                }
            }
            catch (MessageEOFException expected) {}
        } else if (message instanceof ObjectMessage) {
            result = MessagePool.getObjectMessage();
            ((ObjectMessage)((Object)result)).setObject(((ObjectMessage)message).getObject());
        } else if (message instanceof TextMessage) {
            result = MessagePool.getTextMessage();
            ((TextMessage)((Object)result)).setText(((TextMessage)message).getText());
        } else {
            result = MessagePool.getMessage();
        }
        try {
            result.setJMSCorrelationID(message.getJMSCorrelationID());
        }
        catch (JMSException e) {
            result.setJMSCorrelationIDAsBytes(message.getJMSCorrelationIDAsBytes());
        }
        result.setJMSReplyTo(message.getJMSReplyTo());
        result.setJMSType(message.getJMSType());
        Enumeration en = message.getPropertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            try {
                result.setObjectProperty(key, message.getObjectProperty(key));
            }
            catch (JMSException ignored) {
                if (!trace) continue;
                log.trace("Unable to copy property " + key, ignored);
            }
        }
        return result;
    }

    protected void checkClosed() throws JMSException {
        if (this.closed.get()) {
            throw new IllegalStateException("Message producer is closed");
        }
    }
}

