/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.bean;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviceDataSet
implements Serializable {
    private static final long serialVersionUID = -9072139745460507914L;
    private HashMap<String, HashMap<String, ArrayList<CollectorDeviceInfoData>>> deviceMap = new HashMap();

    public void putDeviceList(CollectorDeviceInfoData deviceData) {
        ArrayList<CollectorDeviceInfoData> deviceList;
        String facilitID = deviceData.getFacilityId();
        String deviceType = deviceData.getDeviceType();
        HashMap<String, ArrayList<CollectorDeviceInfoData>> facilityDeviceMap = this.getFacilityDeviceMap(facilitID);
        if (facilityDeviceMap == null) {
            facilityDeviceMap = new HashMap();
            this.deviceMap.put(facilitID, facilityDeviceMap);
        }
        if ((deviceList = facilityDeviceMap.get(deviceType)) == null) {
            deviceList = new ArrayList();
            facilityDeviceMap.put(deviceType, deviceList);
        }
        deviceList.add(deviceData);
    }

    public List<CollectorDeviceInfoData> getDeviceList(String facilityID, String deviceType) {
        HashMap<String, ArrayList<CollectorDeviceInfoData>> facilityDeviceMap = this.getFacilityDeviceMap(facilityID);
        if (facilityDeviceMap != null) {
            return this.getDeviceList(facilityDeviceMap, deviceType);
        }
        return null;
    }

    public List<CollectorDeviceInfoData> getDisk(String facilityID) {
        return this.getDeviceList(facilityID, "disk");
    }

    public List<CollectorDeviceInfoData> getNic(String facilityID) {
        return this.getDeviceList(facilityID, "nic");
    }

    public List<CollectorDeviceInfoData> getAll() {
        ArrayList<CollectorDeviceInfoData> deviceList = new ArrayList<CollectorDeviceInfoData>();
        Set<String> keys = this.deviceMap.keySet();
        for (String facilitID : keys) {
            HashMap<String, ArrayList<CollectorDeviceInfoData>> facilityDeviceMap = this.getFacilityDeviceMap(facilitID);
            Collection<ArrayList<CollectorDeviceInfoData>> dl = facilityDeviceMap.values();
            Iterator<ArrayList<CollectorDeviceInfoData>> itrDl = dl.iterator();
            while (itrDl.hasNext()) {
                deviceList.addAll((Collection<CollectorDeviceInfoData>)itrDl.next());
            }
        }
        return deviceList;
    }

    private HashMap<String, ArrayList<CollectorDeviceInfoData>> getFacilityDeviceMap(String facilityID) {
        return this.deviceMap.get(facilityID);
    }

    private ArrayList<CollectorDeviceInfoData> getDeviceList(HashMap<String, ArrayList<CollectorDeviceInfoData>> facilityDeviceMap, String deviceType) {
        return facilityDeviceMap.get(deviceType);
    }
}

