/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.util;

import com.clustercontrol.performance.bean.CollectorLockKey;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LockManager {
    protected static Log m_log = LogFactory.getLog(LockManager.class);
    private static final long maxLife = 3600000L;
    private static HashMap m_lockList = new HashMap();
    private static HashMap m_lastLockTime = new HashMap();

    public static synchronized void lock(String collectorID, CollectorLockKey key) {
        m_log.debug((Object)("lock() start : Key : " + key.toString() + "  CollectorID :" + collectorID));
        m_lockList.put(key, collectorID);
        m_lastLockTime.put(key, new Date());
        m_log.debug((Object)("lock() end : Key : " + key.toString() + "  CollectorID :" + collectorID));
    }

    public static synchronized boolean isLocked(String collectorID) {
        m_log.debug((Object)("isLocked() start : CollectorID :" + collectorID));
        boolean contains = false;
        ArrayList<CollectorLockKey> delList = new ArrayList<CollectorLockKey>();
        for (CollectorLockKey key : m_lockList.keySet()) {
            Date lastLockTime = (Date)m_lastLockTime.get(key);
            if (lastLockTime.getTime() + 3600000L < System.currentTimeMillis()) {
                delList.add(key);
                continue;
            }
            if (!((String)m_lockList.get(key)).equals(collectorID)) continue;
            contains = true;
        }
        for (CollectorLockKey key : delList) {
            m_log.debug((Object)("isLocked() : timeout  KeyID : " + key.toString() + "  CollectorID : " + collectorID));
            LockManager.unlock(key);
        }
        m_log.debug((Object)("isLocked() end : CollectorID :" + collectorID));
        return contains;
    }

    public static synchronized void unlock(CollectorLockKey key) {
        m_log.debug((Object)("unlock() start : KeyID : " + key.toString() + "  CollectorID : " + m_lockList.get(key)));
        m_lockList.remove(key);
        m_lastLockTime.remove(key);
        m_log.debug((Object)("unlock() end : Key : " + key.toString() + "  CollectorID : " + m_lockList.get(key)));
    }

    private static void printLockList() {
        Set set = m_lockList.keySet();
        for (CollectorLockKey key : set) {
            m_log.debug((Object)("Lock list  Key : " + key.toString() + "\tCollectorID : " + (String)m_lockList.get(key) + "\t  " + m_lastLockTime.get(key)));
        }
    }
}

