/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.postgresforest.Driver;
import org.postgresforest.jdbc3.Jdbc3Connection;
import org.postgresforest.jdbc3.Jdbc3Statement;
import org.postgresforest.util.PSQLException;
import org.postgresforest.util.PSQLState;
import org.postgresforest.vm.AbstractForestConnection;
import org.postgresforest.vm.BrokenNotify_I;
import org.postgresforest.vm.ForestSQLState;
import org.postgresforest.vm.Hash01;
import org.postgresforest.vm.HashLoader;
import org.postgresforest.vm.Hash_I;
import org.postgresforest.vm.LogUtil;
import org.postgresforest.vm.NoBrokenNotifier;
import org.postgresforest.vm.PartitionColumnInfo;

public class GSCdata
extends Thread {
    private static final String[] protocols = new String[]{"jdbc", "postgresql"};
    private static final String PROTOCOL = "jdbc:postgresql:";
    public static final int DIST_CON_ROUND_ROBIN = 0;
    public static final int DIST_CON_FIX = 1;
    public static final int SERVER_RUNNING = 1;
    public static final int SERVER_TROUBLE = -1;
    public static final int TABLE_AVAILABLE = 0;
    public static final int TABLE_UNAVAILABLE = 1;
    public static final int KEY_TYPE_NAME = 0;
    public static final int KEY_TYPE_NO = 1;
    protected static final DateFormat[] m_formatDate = new DateFormat[]{SimpleDateFormat.getDateInstance(1)};
    protected static final DateFormat[] m_formatTime = new DateFormat[]{SimpleDateFormat.getTimeInstance(1)};
    protected static final DateFormat[] m_formatTimeStamp = new DateFormat[]{SimpleDateFormat.getDateTimeInstance(1, 1)};
    protected String[] m_serverURL = new String[2];
    protected int m_reflesh = 0;
    protected int m_timeout = 300;
    protected int m_distCon = 0;
    protected int m_retry = 0;
    protected String m_dbName = null;
    protected Properties m_prop = null;
    protected Driver m_driver = null;
    protected int m_DistSvrIdx = 0;
    protected ArrayList m_servers = null;
    protected HashMap m_tables = null;
    protected SQLException m_thredErr = null;
    protected boolean m_isClosed = false;
    protected boolean m_hasPartition = false;
    protected String m_configID = null;
    protected Date m_configDate = null;
    protected boolean m_partitionMode = false;
    protected boolean m_updateSyncMode = false;
    protected AbstractForestConnection m_forestConnection;
    protected static BrokenNotify_I m_brokenNotifier;
    protected LogUtil m_logUtil;
    protected static String m_client;
    protected boolean m_tableAvailable = false;

    public GSCdata(String gsc, String config, String dbname, Properties info, Driver driver, AbstractForestConnection forestConnection, LogUtil logUtil) throws SQLException {
        this.m_logUtil = logUtil;
        this.m_dbName = dbname;
        this.m_prop = info;
        this.m_driver = driver;
        this.m_forestConnection = forestConnection;
        this.m_configID = config;
        if (this.m_configID == null) {
            this.m_configID = "FOREST_DEFAULT_CONFIG";
        }
        this.getGscList(gsc);
        this.readData();
        this.connectServers();
    }

    protected void connectServers() {
        for (int i = 0; i < this.m_servers.size(); ++i) {
            ServerInfo srvinf = (ServerInfo)this.m_servers.get(i);
            if (srvinf.getStatus() != 1 || srvinf.getConnection() != null) continue;
            String url = srvinf.getUrl() + this.m_dbName;
            try {
                AbstractForestConnection con = (AbstractForestConnection)((Object)this.connect(url));
                con.setLogUtil(this.m_logUtil);
                con._setTransactionIsolation(this.m_forestConnection.isolationLevel);
                con._setAutoCommit(this.m_forestConnection.getAutoCommit());
                srvinf.setConnection((Connection)((Object)con));
                if (!Driver.logInfo) continue;
                this.m_logUtil.info("It connected with the DB server. (" + url + ")");
                continue;
            }
            catch (SQLException e2) {
                srvinf.setStatus(-1);
                this.updateDBstatus(srvinf.getId());
                this.putBrokenLog(srvinf.getUrl(), srvinf.getId(), e2.getMessage(), e2.getSQLState(), "CONNECT");
                if (!Driver.logInfo) continue;
                this.m_logUtil.info("It was not connectable with the DB server. (" + url + ")");
            }
        }
    }

    protected void getGscList(String gscStr) throws SQLException {
        StringTokenizer t = new StringTokenizer(gscStr, ",");
        while (t.hasMoreTokens() && !this.setServers(t.nextToken())) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (Driver.logInfo) {
            this.m_logUtil.info("The updating thread of GSC cash is started.");
        }
        while (true) {
            try {
                if (GSCdata.interrupted()) break;
                GSCdata.sleep(this.m_reflesh);
            }
            catch (InterruptedException e) {
                break;
            }
            GSCdata gSCdata = this;
            synchronized (gSCdata) {
                try {
                    this.readData();
                }
                catch (SQLException e1) {
                    this.m_thredErr = e1;
                    break;
                }
                this.connectServers();
            }
        }
        if (Driver.logInfo) {
            this.m_logUtil.info("The updating thread of GSC cash is ended.");
        }
    }

    public synchronized void setServerBroken(Connection con, String query, Exception ex) throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.chkThredErr();
        for (int i = 0; i < this.m_servers.size(); ++i) {
            ServerInfo srvinf = (ServerInfo)this.m_servers.get(i);
            if (!con.equals(srvinf.getConnection()) || srvinf.getStatus() == -1) continue;
            srvinf.setStatus(-1);
            this.updateDBstatus(srvinf.getId());
            if (ex instanceof SQLException) {
                this.putBrokenLog(srvinf.getUrl(), srvinf.getId(), ex.getMessage(), ((SQLException)ex).getSQLState(), query);
            } else {
                this.putBrokenLog(srvinf.getUrl(), srvinf.getId(), ex.getMessage(), "XX000", query);
            }
            if (Driver.logInfo) {
                this.m_logUtil.info("Server status was set up into the obstacle. (" + srvinf.getUrl() + ")");
            }
            try {
                ((AbstractForestConnection)((Object)con)).closeGD();
            }
            catch (SQLException e1) {
                // empty catch block
            }
            srvinf.setConnection(null);
            break;
        }
    }

    protected void chkThredErr() throws SQLException {
        if (this.m_thredErr != null) {
            throw this.m_thredErr;
        }
    }

    public int getTimeout() {
        return this.m_timeout;
    }

    public synchronized boolean isPartition(String tableName) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        return tblinfo.isPartition();
    }

    protected TableInfo getTableInfo(String tableName) throws PSQLException {
        String tblNameL = tableName.toLowerCase();
        TableInfo tblinfo = (TableInfo)this.m_tables.get(tblNameL);
        if (tblinfo == null) {
            throw new PSQLException("postgresql.forest.notable", (PSQLState)ForestSQLState.INTERNAL_ERROR, tableName);
        }
        return tblinfo;
    }

    public synchronized int getPartCount(String tableName) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        return tblinfo.getPartitionNum();
    }

    public synchronized ArrayList getPartCol(String tableName) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        ArrayList collist = tblinfo.getColumnList();
        return collist;
    }

    public synchronized String[] getPartColNames(String tableName) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        ArrayList collist = tblinfo.getColumnList();
        if (collist == null) {
            return new String[0];
        }
        String[] colNames = new String[collist.size()];
        for (int i = 0; i < colNames.length; ++i) {
            PartitionColumnInfo colinfo = (PartitionColumnInfo)collist.get(i);
            colNames[i] = colinfo.getName();
        }
        return colNames;
    }

    public synchronized int[] getPartColNums(String tableName) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        ArrayList collist = tblinfo.getColumnList();
        int[] colNums = new int[collist.size()];
        for (int i = 0; i < colNums.length; ++i) {
            PartitionColumnInfo colinfo = (PartitionColumnInfo)collist.get(i);
            colNums[i] = colinfo.getNumber();
        }
        return colNums;
    }

    public synchronized Connection getDistServer(String[] table) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(table[0]);
        ArrayList svrlist = (ArrayList)tblinfo.getServers().clone();
        for (int i = 1; i < table.length; ++i) {
            TableInfo tblinfoWk = this.getTableInfo(table[i]);
            ArrayList svrlistWk = tblinfoWk.getServers();
            Iterator iter = svrlist.iterator();
            while (iter.hasNext()) {
                ServerInfo svrInfo = (ServerInfo)iter.next();
                if (svrlistWk.contains(svrInfo)) continue;
                iter.remove();
            }
        }
        int serverIdx = this.getSvrIdx();
        if (serverIdx < 0) {
            throw new PSQLException("postgresql.forest.server.noservers", ForestSQLState.INTERNAL_ERROR);
        }
        for (int i = 0; i < this.m_servers.size(); ++i) {
            ServerInfo svrInfo = (ServerInfo)this.m_servers.get(serverIdx);
            svrInfo = (ServerInfo)this.m_servers.get(serverIdx);
            if (svrInfo.getStatus() == 1 && svrlist.contains(svrInfo)) {
                return svrInfo.getConnection();
            }
            if (this.m_servers.size() > ++serverIdx) continue;
            serverIdx = 0;
        }
        throw new PSQLException("postgresql.forest.server.noservers", ForestSQLState.INTERNAL_ERROR);
    }

    public synchronized Connection getDistServer() throws SQLException {
        this.chkThredErr();
        int serverIdx = this.getSvrIdx();
        if (serverIdx < 0) {
            throw new PSQLException("postgresql.forest.server.noservers", ForestSQLState.INTERNAL_ERROR);
        }
        for (int i = 0; i < this.m_servers.size(); ++i) {
            ServerInfo svrInfo = (ServerInfo)this.m_servers.get(serverIdx);
            svrInfo = (ServerInfo)this.m_servers.get(serverIdx);
            if (svrInfo.getStatus() == 1) {
                return svrInfo.getConnection();
            }
            if (this.m_servers.size() > ++serverIdx) continue;
            serverIdx = 0;
        }
        throw new PSQLException("postgresql.forest.server.noservers", ForestSQLState.INTERNAL_ERROR);
    }

    public synchronized Connection getDistServer(String tableName, int PartNo) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        ArrayList svrList = tblinfo.getServers(PartNo);
        for (int i = 0; i < svrList.size(); ++i) {
            ServerInfo srvinfo = (ServerInfo)svrList.get(i);
            if (srvinfo.getStatus() != 1) continue;
            return srvinfo.getConnection();
        }
        throw new PSQLException("postgresql.forest.server.noservers", ForestSQLState.INTERNAL_ERROR);
    }

    public synchronized ArrayList getDistServerList(String tableName, String[] tableList) throws SQLException {
        int i;
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        ArrayList srvlist = tblinfo.getServers();
        ArrayList<ServerInfo> distSvrlist = new ArrayList<ServerInfo>();
        for (i = 0; i < srvlist.size(); ++i) {
            ServerInfo srvinfo = (ServerInfo)srvlist.get(i);
            if (srvinfo.getStatus() != 1) continue;
            distSvrlist.add(srvinfo);
        }
        for (i = 0; i < tableList.length; ++i) {
            TableInfo tblinfoWk = this.getTableInfo(tableList[i]);
            ArrayList srvlistWk = tblinfoWk.getServers();
            if (srvlistWk.containsAll(distSvrlist)) continue;
            throw new PSQLException("postgresql.forest.server.connotserver", ForestSQLState.INTERNAL_ERROR);
        }
        return this.getDistServerList(tableName);
    }

    public synchronized ArrayList getDistServerList(String tableName) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        ArrayList srvlist = tblinfo.getServers();
        ArrayList<Connection> conlist = new ArrayList<Connection>();
        for (int i = 0; i < srvlist.size(); ++i) {
            ServerInfo srvinfo = (ServerInfo)srvlist.get(i);
            if (srvinfo.getStatus() != 1) continue;
            conlist.add(srvinfo.getConnection());
        }
        if (conlist.size() == 0) {
            throw new PSQLException("postgresql.forest.server.noservers", ForestSQLState.INTERNAL_ERROR);
        }
        return conlist;
    }

    public synchronized ArrayList getDistServerList(String tableName, int PartNo) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        if (tblinfo == null) {
            throw new PSQLException("postgresql.forest.notable", (PSQLState)ForestSQLState.INTERNAL_ERROR, tableName);
        }
        ArrayList srvlist = tblinfo.getServers(PartNo);
        ArrayList<Connection> conlist = new ArrayList<Connection>();
        for (int i = 0; i < srvlist.size(); ++i) {
            ServerInfo srvinfo = (ServerInfo)srvlist.get(i);
            if (srvinfo.getStatus() != 1) continue;
            conlist.add(srvinfo.getConnection());
        }
        if (conlist.size() == 0) {
            throw new PSQLException("postgresql.forest.server.noservers", ForestSQLState.INTERNAL_ERROR);
        }
        return conlist;
    }

    public synchronized ArrayList getDistServerList() throws SQLException {
        this.chkThredErr();
        ArrayList<Connection> conlist = new ArrayList<Connection>();
        for (int i = 0; i < this.m_servers.size(); ++i) {
            ServerInfo srvinfo = (ServerInfo)this.m_servers.get(i);
            if (srvinfo.getStatus() != 1) continue;
            conlist.add(srvinfo.getConnection());
        }
        if (conlist.size() == 0) {
            throw new PSQLException("postgresql.forest.server.noservers", ForestSQLState.INTERNAL_ERROR);
        }
        return conlist;
    }

    public int getServerCount() throws SQLException {
        return this.m_servers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized int getPartNo(String table, HashMap valueMap, int type) throws SQLException {
        Hash_I hashobj;
        this.chkThredErr();
        TableInfo tblinf = this.getTableInfo(table);
        Hash_I hash_I = hashobj = tblinf.getHash();
        // MONITORENTER : hash_I
        ArrayList colList = tblinf.getColumnList();
        hashobj.clearCol();
        hashobj.setPartNum(this.getPartCount(table));
        int i = 0;
        while (true) {
            if (i >= colList.size()) {
                // MONITOREXIT : hash_I
                return hashobj.getNodeNo();
            }
            PartitionColumnInfo colinfo = (PartitionColumnInfo)colList.get(i);
            String value = null;
            if (type == 0) {
                value = (String)valueMap.get(colinfo.getName());
            } else {
                Integer colNum = new Integer(colinfo.getNumber());
                value = (String)valueMap.get(colNum);
            }
            if (value == null) {
                throw new PSQLException("postgresql.forest.partition.null", ForestSQLState.INTERNAL_ERROR);
            }
            switch (colinfo.getType()) {
                case 4: 
                case 5: {
                    hashobj.addCol(new Double(value).intValue());
                    break;
                }
                case 1: 
                case 12: {
                    value = value.replaceAll("\\\\n", "\n");
                    value = value.replaceAll("\\\\t", "\t");
                    value = value.replaceAll("\\\\r", "\r");
                    value = value.replaceAll("''", "\\'");
                    hashobj.addCol(value);
                    break;
                }
                case 91: {
                    int j;
                    long timelong;
                    DateFormat[] dateFormatArray;
                    try {
                        hashobj.addCol(Date.valueOf(value));
                    }
                    catch (Exception e) {
                        dateFormatArray = m_formatDate;
                        // MONITORENTER : m_formatDate
                        timelong = 0L;
                        for (j = 0; j < m_formatDate.length; ++j) {
                            try {
                                timelong = m_formatDate[j].parse(value).getTime();
                                hashobj.addCol(new Date(timelong));
                                break;
                            }
                            catch (ParseException e1) {
                                continue;
                            }
                        }
                        if (timelong == 0L) {
                            throw new PSQLException("postgresql.forest.partition.type", ForestSQLState.INTERNAL_ERROR);
                        }
                        // MONITOREXIT : dateFormatArray
                    }
                    break;
                }
                case 92: {
                    int j;
                    long timelong;
                    DateFormat[] dateFormatArray;
                    try {
                        hashobj.addCol(Time.valueOf(value));
                    }
                    catch (Exception e) {
                        dateFormatArray = m_formatTime;
                        // MONITORENTER : m_formatTime
                        timelong = 0L;
                        for (j = 0; j < m_formatTime.length; ++j) {
                            try {
                                timelong = m_formatTime[j].parse(value).getTime();
                                hashobj.addCol(new Time(timelong));
                                break;
                            }
                            catch (ParseException e1) {
                                continue;
                            }
                        }
                        if (timelong == 0L) {
                            throw new PSQLException("postgresql.forest.partition.type", ForestSQLState.INTERNAL_ERROR);
                        }
                        // MONITOREXIT : dateFormatArray
                    }
                    break;
                }
                case 93: {
                    int j;
                    long timelong;
                    DateFormat[] dateFormatArray;
                    try {
                        hashobj.addCol(Timestamp.valueOf(value));
                    }
                    catch (Exception e) {
                        dateFormatArray = m_formatTimeStamp;
                        // MONITORENTER : m_formatTimeStamp
                        timelong = 0L;
                        for (j = 0; j < m_formatTimeStamp.length; ++j) {
                            try {
                                timelong = m_formatTimeStamp[j].parse(value).getTime();
                                hashobj.addCol(new Time(timelong));
                                break;
                            }
                            catch (ParseException e1) {
                                continue;
                            }
                        }
                        if (timelong == 0L) {
                            throw new PSQLException("postgresql.forest.partition.type", ForestSQLState.INTERNAL_ERROR);
                        }
                        // MONITOREXIT : dateFormatArray
                    }
                    break;
                }
                default: {
                    throw new PSQLException("postgresql.forest.partition.type", ForestSQLState.INTERNAL_ERROR);
                }
            }
            ++i;
        }
    }

    public synchronized void close() {
        for (int i = 0; i < this.m_servers.size(); ++i) {
            ServerInfo srvinf = (ServerInfo)this.m_servers.get(i);
            Connection con = srvinf.getConnection();
            try {
                if (con == null) continue;
                ((AbstractForestConnection)((Object)con)).closeGD();
                if (!Driver.logInfo) continue;
                this.m_logUtil.info("Connection with DB server was closed. (" + ((AbstractForestConnection)((Object)con)).getURL() + ")");
                continue;
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        try {
            this.interrupt();
            this.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.m_isClosed = true;
    }

    protected int getSvrIdx() {
        boolean retry = false;
        for (int i = 0; i < this.m_servers.size(); ++i) {
            ServerInfo svrInfo;
            if (this.m_distCon == 0 || retry) {
                ++this.m_DistSvrIdx;
                if (this.m_servers.size() <= this.m_DistSvrIdx) {
                    this.m_DistSvrIdx = 0;
                }
            }
            if ((svrInfo = (ServerInfo)this.m_servers.get(this.m_DistSvrIdx)).getStatus() == 1) {
                return this.m_DistSvrIdx;
            }
            retry = true;
        }
        return -1;
    }

    protected synchronized void readData() throws SQLException {
        for (int i = 0; i < this.m_serverURL.length; ++i) {
            block8: {
                String serverURL = this.m_serverURL[i];
                if (serverURL == null) continue;
                try {
                    Connection con = this.connect(serverURL);
                    boolean isReload = this.readConfig(con);
                    ArrayList servers = this.readServerData(con);
                    if (isReload) {
                        HashMap tables = this.readTableData(con, servers);
                        this.setGscData(servers, tables);
                        if (this.m_distCon == 1) {
                            this.m_DistSvrIdx = (int)((double)this.m_servers.size() * Math.random());
                        }
                    } else if (this.m_servers != null) {
                        this.setGscStatus(servers);
                    }
                    ((AbstractForestConnection)((Object)con)).closeGD();
                    if (!Driver.logInfo) break block8;
                    this.m_logUtil.info("GSC was read. (" + serverURL + ")");
                }
                catch (SQLException e) {
                    if (Driver.logInfo) {
                        this.m_logUtil.info("Reading of GSC went wrong. (" + serverURL + ")");
                        this.m_logUtil.info("A server(" + serverURL + ") is separated.");
                    }
                    this.m_serverURL[i] = null;
                    m_brokenNotifier.notifyGscBroken(serverURL, e.getMessage(), e.getSQLState());
                    continue;
                }
            }
            return;
        }
        throw new PSQLException("postgresql.forest.gsc.notexist", ForestSQLState.INTERNAL_ERROR);
    }

    protected synchronized void setGscData(ArrayList servers, HashMap tables) {
        if (this.m_servers == null) {
            this.m_servers = servers;
        } else {
            HashMap svrMap = this.getServerMap(this.m_servers);
            for (int i = 0; i < servers.size(); ++i) {
                ServerInfo newSvrInfo = (ServerInfo)servers.get(i);
                Integer dbNo = new Integer(newSvrInfo.getDbNo());
                ServerInfo oldSvrInfo = (ServerInfo)svrMap.get(dbNo);
                if (oldSvrInfo == null) continue;
                int oldStatus = oldSvrInfo.getStatus();
                int newStatus = newSvrInfo.getStatus();
                if (oldStatus == 1 && newStatus == -1) {
                    Connection con = oldSvrInfo.getConnection();
                    if (con != null) {
                        try {
                            ((AbstractForestConnection)((Object)con)).closeGD();
                        }
                        catch (SQLException e) {}
                    }
                } else {
                    newSvrInfo.setConnection(oldSvrInfo.getConnection());
                }
                svrMap.remove(dbNo);
            }
            this.m_servers = servers;
            Iterator iter = svrMap.values().iterator();
            while (iter.hasNext()) {
                ServerInfo rmSvrInfo = (ServerInfo)iter.next();
                try {
                    Connection con = rmSvrInfo.getConnection();
                    ((AbstractForestConnection)((Object)con)).closeGD();
                }
                catch (Exception e) {}
            }
        }
        this.m_tables = tables;
        this.m_hasPartition = false;
        this.m_tableAvailable = true;
        Iterator iter = this.m_tables.values().iterator();
        while (iter.hasNext()) {
            TableInfo tableInfo = (TableInfo)iter.next();
            if (tableInfo.isPartition()) {
                this.m_hasPartition = true;
            }
            if (tableInfo.getStatus() != 1) continue;
            this.m_tableAvailable = false;
        }
        if (Driver.logInfo) {
            if (this.m_hasPartition) {
                this.m_logUtil.info("DB Partition.");
            } else {
                this.m_logUtil.info("DB NoPartition.");
            }
        }
    }

    protected synchronized void setGscStatus(ArrayList servers) throws SQLException {
        if (this.m_servers == null) {
            this.m_servers = servers;
        } else {
            int cntServers = this.m_servers.size();
            if (cntServers != servers.size()) {
                throw new PSQLException("postgresql.forest.gsc.notexist", ForestSQLState.INTERNAL_ERROR);
            }
            for (int i = 0; i < cntServers; ++i) {
                int newStatus;
                ServerInfo newSvrInfo = (ServerInfo)servers.get(i);
                ServerInfo oldSvrInfo = (ServerInfo)this.m_servers.get(i);
                if (newSvrInfo.getId() == oldSvrInfo.getId()) {
                    Connection con;
                    int oldStatus = oldSvrInfo.getStatus();
                    newStatus = newSvrInfo.getStatus();
                    if (oldStatus == 1 && newStatus == -1 && (con = oldSvrInfo.getConnection()) != null) {
                        try {
                            ((AbstractForestConnection)((Object)con)).closeGD();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                        oldSvrInfo.setConnection(null);
                    }
                } else {
                    throw new PSQLException("postgresql.forest.gsc.notexist", ForestSQLState.INTERNAL_ERROR);
                }
                oldSvrInfo.setStatus(newStatus);
            }
        }
    }

    protected HashMap readTableData(Connection con, ArrayList serverList) throws SQLException {
        HashLoader hloader = HashLoader.getIncetance(false);
        HashMap<String, TableInfo> tables = new HashMap<String, TableInfo>();
        HashMap serverMap = this.getServerMap(serverList);
        String sql = "select * from FOREST_TABLEPART where DBNAME = '" + this.m_dbName + "'";
        Statement smt = con.createStatement();
        ResultSet rs = ((Jdbc3Statement)smt).executeQueryGD(sql);
        while (rs.next()) {
            String className;
            TableInfo tblInfo = new TableInfo();
            String tableName = rs.getString("TABLE_NAME").toLowerCase();
            tblInfo.setName(tableName);
            sql = "select * from FOREST_TABLEPARTDTL where DBNAME = '" + this.m_dbName + "'" + " and lower(TABLE_NAME) = '" + tableName + "'" + " order by PRIORITY";
            Statement smt2 = con.createStatement();
            ResultSet rs2 = ((Jdbc3Statement)smt2).executeQueryGD(sql);
            while (rs2.next()) {
                Integer dbNo = new Integer(rs2.getInt("DBNO"));
                ServerInfo svrInfo = (ServerInfo)serverMap.get(dbNo);
                int partNo = rs2.getInt("PART_NO");
                tblInfo.setServers(partNo, svrInfo);
            }
            smt2.close();
            tblInfo.setType(rs.getInt("PART_TYPE"));
            tblInfo.setPartitionNum(rs.getInt("PART_COUNT"));
            tblInfo.setStatus(rs.getInt("STATUS"));
            if (tblInfo.isPartition()) {
                ArrayList clmlist = this.readCollumnData(con, tableName);
                tblInfo.setColumnList(clmlist);
            }
            if ((className = rs.getString("HASH_NAME")) == null) {
                tblInfo.setHash(new Hash01());
            } else {
                try {
                    Hash_I hashobj = (Hash_I)hloader.loadClass(className, con).newInstance();
                    tblInfo.setHash(hashobj);
                }
                catch (Exception e) {
                    throw new PSQLException("postgresql.forest.partition.function", ForestSQLState.INTERNAL_ERROR, className, e.getMessage());
                }
            }
            tables.put(tableName, tblInfo);
        }
        smt.close();
        return tables;
    }

    protected HashMap getServerMap(ArrayList serverList) {
        HashMap<Integer, ServerInfo> serverMap = new HashMap<Integer, ServerInfo>();
        for (int i = 0; i < serverList.size(); ++i) {
            ServerInfo srvInfo = (ServerInfo)serverList.get(i);
            Integer dbNo = new Integer(srvInfo.getDbNo());
            serverMap.put(dbNo, srvInfo);
        }
        return serverMap;
    }

    protected ArrayList readCollumnData(Connection con, String tableName) throws SQLException {
        ArrayList<PartitionColumnInfo> clmlist = new ArrayList<PartitionColumnInfo>();
        String sql = "select * from FOREST_PARTATR where DBNAME = '" + this.m_dbName + "' " + "and lower(TABLE_NAME) = '" + tableName + "'";
        Statement smt = con.createStatement();
        ResultSet rs = ((Jdbc3Statement)smt).executeQueryGD(sql);
        while (rs.next()) {
            PartitionColumnInfo clmInfo = new PartitionColumnInfo();
            clmInfo.setName(rs.getString("COLUMN_NAME").toLowerCase());
            clmInfo.setNumber(rs.getInt("COLUMN_NO"));
            int clmType = ((AbstractForestConnection)((Object)con)).getSQLType(rs.getString("COLUMN_TYPE").toLowerCase());
            clmInfo.setType(clmType);
            clmlist.add(clmInfo);
        }
        smt.close();
        return clmlist;
    }

    protected ArrayList readServerData(Connection con) throws SQLException {
        StringBuffer sql = new StringBuffer(256);
        sql.append("select * ");
        sql.append(" from FOREST_SERVER as a, FOREST_SERVDB as b ");
        sql.append(" where a.SERVERID = b.SERVERID ");
        sql.append(" and b.DBNAME = '");
        sql.append(this.m_dbName);
        sql.append("'  order by a.SERVERID");
        ArrayList<ServerInfo> servers = new ArrayList<ServerInfo>();
        Statement smt = con.createStatement();
        ResultSet rs = ((Jdbc3Statement)smt).executeQueryGD(sql.toString());
        while (rs.next()) {
            ServerInfo srvInfo = new ServerInfo();
            srvInfo.setId(rs.getInt("SERVERID"));
            srvInfo.setStatus(rs.getInt("STATUS"));
            srvInfo.setUrl(rs.getString("URL"));
            srvInfo.setDbNo(rs.getInt("DBNO"));
            servers.add(srvInfo);
        }
        smt.close();
        return servers;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean readConfig(Connection con) throws SQLException {
        Statement smt;
        block16: {
            boolean bl;
            StringBuffer sql = new StringBuffer("select * from FOREST_CONFIG ");
            sql.append("where CONFIGID = '");
            sql.append(this.m_configID);
            sql.append("'");
            smt = null;
            try {
                try {
                    smt = con.createStatement();
                    ResultSet rs = ((Jdbc3Statement)smt).executeQueryGD(sql.toString());
                    rs.next();
                    Date configDate = new Date(rs.getTimestamp("UPDATE_DATE").getTime());
                    if (this.m_configDate != null && configDate.equals(this.m_configDate)) break block16;
                    this.m_configDate = configDate;
                    this.m_partitionMode = rs.getBoolean("PERTITION_MODE");
                    this.m_updateSyncMode = rs.getBoolean("SYNCRONIZE_MODE");
                    int reflesh = rs.getInt("CACHE_REFLESH") * 1000;
                    if (this.m_reflesh != reflesh) {
                        if (this.m_reflesh == 0) {
                            this.m_reflesh = reflesh;
                            this.setDaemon(true);
                            this.start();
                        } else if (reflesh == 0) {
                            this.interrupt();
                        }
                        this.m_reflesh = reflesh;
                    }
                    this.m_timeout = rs.getInt("DEFECT_TIMEOUT");
                    int distCon = rs.getInt("DISTRIBUTED_CONNECTION");
                    if (distCon == 1 && this.m_distCon != distCon) {
                        this.m_distCon = distCon;
                    }
                    this.m_retry = rs.getInt("RETRY_COUNT");
                    if (Driver.logInfo) {
                        this.m_logUtil.info("The configuration file was read. (ID:" + this.m_configID + ")");
                    }
                    bl = true;
                    Object var10_10 = null;
                }
                catch (SQLException e) {
                    if (!Driver.logInfo) throw new PSQLException("postgresql.forest.conf", ForestSQLState.INTERNAL_ERROR, this.m_configID, e.getMessage());
                    this.m_logUtil.info("Reading of a configuration file went wrong. (ID:" + this.m_configID + ")");
                    throw new PSQLException("postgresql.forest.conf", ForestSQLState.INTERNAL_ERROR, this.m_configID, e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (smt == null) throw throwable;
                    smt.close();
                    throw throwable;
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (SQLException e1) {
                // empty catch block
                return bl;
            }
            if (smt == null) return bl;
            smt.close();
            return bl;
        }
        Object var10_11 = null;
        try {}
        catch (SQLException e1) {}
        if (smt == null) return false;
        smt.close();
        return false;
    }

    protected void updateDBstatus(int id) {
        StringBuffer sql = new StringBuffer(128);
        sql.append("update  FOREST_SERVER ");
        sql.append(" set STATUS = ");
        sql.append(-1);
        sql.append(" where SERVERID = ");
        sql.append(id);
        for (int i = 0; i < this.m_serverURL.length; ++i) {
            if (this.m_serverURL[i] == null) continue;
            try {
                Connection con = this.connect(this.m_serverURL[i]);
                Statement smt = con.createStatement();
                ((Jdbc3Statement)smt).executeUpdateGD(sql.toString());
                smt.close();
                ((AbstractForestConnection)((Object)con)).closeGD();
                continue;
            }
            catch (SQLException e) {
                m_brokenNotifier.notifyGscBroken(this.m_serverURL[i], e.getMessage(), e.getSQLState());
                this.m_serverURL[i] = null;
            }
        }
    }

    protected void putBrokenLog(String url, int id, String msg, String status, String query) {
        StringBuffer sql = new StringBuffer(256);
        sql.append("INSERT INTO forest_brokenlog (serverid, datetime, msg, status, client, query) ");
        sql.append("VALUES( ");
        sql.append(id);
        sql.append(", '");
        sql.append(new java.util.Date());
        sql.append("', '");
        sql.append(msg);
        sql.append("', '");
        sql.append(status);
        sql.append(msg);
        sql.append("', '");
        sql.append(m_client);
        sql.append("', '");
        sql.append(query.replaceAll("'", "''"));
        sql.append("')");
        m_brokenNotifier.notifyServerBroken(url, msg, status, query);
        for (int i = 0; i < this.m_serverURL.length; ++i) {
            String serverURL = this.m_serverURL[i];
            if (serverURL == null) continue;
            try {
                Connection con = this.connect(serverURL);
                Statement smt = con.createStatement();
                ((Jdbc3Statement)smt).executeUpdateGD(sql.toString());
                smt.close();
                ((AbstractForestConnection)((Object)con)).closeGD();
                continue;
            }
            catch (SQLException e) {
                System.err.println(sql);
                e.printStackTrace();
                this.m_serverURL[i] = null;
                m_brokenNotifier.notifyGscBroken(serverURL, e.getMessage(), e.getSQLState());
            }
        }
    }

    protected Connection connect(String srcURL) throws SQLException {
        Properties props = null;
        String url = PROTOCOL + srcURL;
        props = this.parseURL(url, this.m_prop);
        if (props == null) {
            if (Driver.logDebug) {
                this.m_logUtil.debug("Error in url" + url);
            }
            return null;
        }
        try {
            if (Driver.logDebug) {
                this.m_logUtil.debug("connect " + url);
            }
            Jdbc3Connection con = (Jdbc3Connection)Class.forName("org.postgresforest.jdbc3.Jdbc3Connection").newInstance();
            String host = props.getProperty("PGHOST", "localhost");
            int port = Integer.parseInt(props.getProperty("PGPORT", "5432"));
            String database = props.getProperty("PGDBNAME", "");
            con.openConnection(host, port, props, database, url, this.m_driver);
            return con;
        }
        catch (ClassNotFoundException ex) {
            if (Driver.logDebug) {
                this.m_logUtil.debug("error", ex);
            }
            throw new PSQLException("postgresql.jvm.version", (Object)ex);
        }
        catch (PSQLException ex1) {
            throw ex1;
        }
        catch (Exception ex2) {
            if (Driver.logDebug) {
                this.m_logUtil.debug("error", ex2);
            }
            throw new PSQLException("postgresql.unusual", (Object)ex2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Properties parseURL(String url, Properties defaults) throws SQLException {
        int state = -1;
        Properties urlProps = new Properties(defaults);
        String key = "";
        String value = "";
        StringTokenizer st = new StringTokenizer(url, ":/;=&?", true);
        int count = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (count <= 3) {
                if (count % 2 != 1 || !token.equals(":")) {
                    if (count % 2 != 0) return null;
                    boolean found = count == 0;
                    for (int tmp = 0; tmp < protocols.length; ++tmp) {
                        if (!token.equals(protocols[tmp]) || count != 2 || tmp <= 0) continue;
                        urlProps.put("Protocol", token);
                        found = true;
                    }
                    if (!found) {
                        return null;
                    }
                }
            } else if (count > 3) {
                if (count == 4 && token.equals("/")) {
                    state = 0;
                } else if (count == 4) {
                    urlProps.put("PGDBNAME", token);
                    state = -2;
                } else if (count == 5 && state == 0 && token.equals("/")) {
                    state = 1;
                } else {
                    if (count == 5 && state == 0) {
                        return null;
                    }
                    if (count == 6 && state == 1) {
                        urlProps.put("PGHOST", token);
                    } else if (count == 7 && token.equals(":")) {
                        state = 2;
                    } else if (count == 8 && state == 2) {
                        try {
                            Integer portNumber = Integer.decode(token);
                            urlProps.put("PGPORT", portNumber.toString());
                        }
                        catch (Exception e) {
                            return null;
                        }
                    } else if (!(count != 7 && count != 9 || state != 1 && state != 2 || !token.equals("/"))) {
                        state = -1;
                    } else if (state == -1) {
                        urlProps.put("PGDBNAME", token);
                        state = -2;
                    } else if (state <= -2 && count % 2 == 1) {
                        if (token.equals(";") || token.equals("?") || token.equals("&")) {
                            state = -3;
                        } else if (token.equals("=")) {
                            state = -5;
                        }
                    } else if (state <= -2 && count % 2 == 0) {
                        if (state == -3) {
                            key = token;
                        } else if (state == -5) {
                            value = token;
                            urlProps.put(key, value);
                            state = -2;
                        }
                    }
                }
            }
            ++count;
        }
        return urlProps;
    }

    public boolean isClosed() {
        return this.m_isClosed;
    }

    public void setClosed(boolean closed) {
        this.m_isClosed = closed;
    }

    public int getRetry() {
        return this.m_retry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setServers(String url) {
        Connection con = null;
        String sql = "select URL, DBNAME from FOREST_GSC g, FOREST_SERVER s where g.SERVERID = s.SERVERID";
        ArrayList<String> servers = new ArrayList<String>();
        boolean ret = false;
        try {
            con = this.connect(url);
            Statement smt = con.createStatement();
            ResultSet rs = ((Jdbc3Statement)smt).executeQueryGD(sql);
            while (rs.next()) {
                String gscUrl = rs.getString("URL") + rs.getString("DBNAME");
                if (!url.equals(gscUrl)) {
                    servers.add(gscUrl);
                    continue;
                }
                servers.add(0, gscUrl);
            }
            smt.close();
        }
        catch (SQLException e) {
            if (Driver.logDebug) {
                this.m_logUtil.debug(e.getMessage());
            }
        }
        finally {
            try {
                ((AbstractForestConnection)((Object)con)).closeGD();
            }
            catch (Exception e1) {}
        }
        if (servers.size() > 0) {
            this.m_serverURL = servers.toArray(new String[0]);
            ret = true;
        }
        return ret;
    }

    public boolean hasPartition() {
        return this.m_hasPartition;
    }

    public LogUtil getLogUtil() {
        return this.m_logUtil;
    }

    public boolean canPartitionMode() {
        return this.m_partitionMode;
    }

    public boolean getUpdateSyncMode() {
        return this.m_updateSyncMode;
    }

    public void setUpdateSyncMode(boolean b) {
        this.m_updateSyncMode = b;
    }

    public synchronized boolean isPartition2(String tableName) throws SQLException {
        this.chkThredErr();
        TableInfo tblinfo = this.getTableInfo(tableName);
        return tblinfo.isPartition2();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected ResultSet executeQueryGSC(String sql) throws SQLException {
        for (int i = 0; i < this.m_serverURL.length; ++i) {
            if (this.m_serverURL[i] == null) continue;
            Connection con = null;
            con = this.connect(this.m_serverURL[i]);
            Statement smt = con.createStatement();
            ResultSet resultSet = ((Jdbc3Statement)smt).executeQueryGD(sql);
            Object var7_6 = null;
            try {
                if (con != null) {
                    ((AbstractForestConnection)((Object)con)).closeGD();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            return resultSet;
            catch (SQLException e) {
                try {
                    var7_6 = null;
                }
                catch (Throwable throwable) {
                    var7_6 = null;
                    try {
                        if (con != null) {
                            ((AbstractForestConnection)((Object)con)).closeGD();
                        }
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (con == null) continue;
                    ((AbstractForestConnection)((Object)con)).closeGD();
                }
                catch (SQLException e1) {}
                continue;
            }
        }
        throw new PSQLException("postgresql.forest.gsc.notexist", ForestSQLState.INTERNAL_ERROR);
    }

    public synchronized boolean isTableAvailable() {
        return this.m_tableAvailable;
    }

    static {
        try {
            m_client = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e1) {
            m_client = "UnknownHost";
        }
        try {
            m_brokenNotifier = (BrokenNotify_I)Class.forName("org.postgresforest.vm.BrokenNotifier").newInstance();
        }
        catch (Exception e) {
            m_brokenNotifier = new NoBrokenNotifier();
        }
    }

    protected class TableInfo {
        protected String m_name;
        protected HashMap m_servers = new HashMap();
        protected ArrayList m_columnList;
        protected int m_partitionNum;
        protected int m_type;
        protected Hash_I m_Hash = null;
        protected int m_status;

        protected TableInfo() {
        }

        public ArrayList getColumnList() {
            return this.m_columnList;
        }

        public String getName() {
            return this.m_name;
        }

        public ArrayList getServers() {
            ArrayList<ServerInfo> servers = new ArrayList<ServerInfo>();
            Iterator iter = this.m_servers.values().iterator();
            while (iter.hasNext()) {
                ArrayList svrList = (ArrayList)iter.next();
                for (int i = 0; i < svrList.size(); ++i) {
                    ServerInfo srvinfo = (ServerInfo)svrList.get(i);
                    if (servers.contains(srvinfo)) continue;
                    servers.add(srvinfo);
                }
            }
            return servers;
        }

        public ArrayList getServers(int partNo) {
            return (ArrayList)this.m_servers.get(new Integer(partNo));
        }

        public void setColumnList(ArrayList list) {
            this.m_columnList = list;
        }

        public void setName(String string) {
            this.m_name = string;
        }

        public void setServers(int partNo, ArrayList list) {
            this.m_servers.put(new Integer(partNo), list);
        }

        public void setServers(int partNo, ServerInfo serverInfo) {
            ArrayList<ServerInfo> serverList = this.getServers(partNo);
            if (serverList == null) {
                serverList = new ArrayList<ServerInfo>();
                serverList.add(serverInfo);
                this.setServers(partNo, serverList);
            } else {
                serverList.add(serverInfo);
            }
        }

        public boolean isPartition() {
            return this.m_partitionNum > 1;
        }

        public int getPartitionNum() {
            return this.m_partitionNum;
        }

        public int getType() {
            return this.m_type;
        }

        public void setPartitionNum(int i) {
            this.m_partitionNum = i;
        }

        public void setType(int i) {
            this.m_type = i;
        }

        public Hash_I getHash() {
            return this.m_Hash;
        }

        public void setHash(Hash_I hash_I) {
            this.m_Hash = hash_I;
        }

        public boolean isPartition2() {
            return this.m_type == 2;
        }

        public int getStatus() {
            return this.m_status;
        }

        public void setStatus(int status) {
            this.m_status = status;
        }
    }

    protected class ServerInfo {
        protected int m_id;
        protected int m_dbNo;
        protected String m_url;
        protected int m_status;
        protected Connection m_con;

        protected ServerInfo() {
        }

        public int getId() {
            return this.m_id;
        }

        public int getStatus() {
            return this.m_status;
        }

        public String getUrl() {
            return this.m_url;
        }

        public void setId(int i) {
            this.m_id = i;
        }

        public void setStatus(int i) {
            this.m_status = i;
        }

        public void setUrl(String string) {
            this.m_url = string;
        }

        public Connection getConnection() {
            return this.m_con;
        }

        public void setConnection(Connection connection) {
            this.m_con = connection;
        }

        public int getDbNo() {
            return this.m_dbNo;
        }

        public void setDbNo(int i) {
            this.m_dbNo = i;
        }
    }
}

