/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.loading;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.loading.MLet;
import org.jboss.logging.Logger;
import org.jboss.mx.loading.ClassLoaderUtils;
import org.jboss.mx.loading.ClassToStringAction;
import org.jboss.mx.loading.LoaderRepository;
import org.jboss.mx.loading.MLetRepositoryClassLoader;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.loading.ResourceInfo;
import org.jboss.mx.loading.UnifiedClassLoader;
import org.jboss.mx.loading.UnifiedClassLoader3;
import org.jboss.mx.loading.UnifiedLoaderRepository3MBean;
import org.jboss.mx.util.JBossNotificationBroadcasterSupport;

public class UnifiedLoaderRepository3
extends LoaderRepository
implements MBeanRegistration,
NotificationEmitter,
UnifiedLoaderRepository3MBean {
    private static final Logger log = Logger.getLogger(UnifiedLoaderRepository3.class);
    private static int addedCount;
    private static final int LEGACY_MODE = 0;
    private static final int WEAK_REFERENCE_MODE = 1;
    private static final int NO_NOTIFICATION_MODE = 2;
    private static int NOTIFICATION_MODE;
    private CopyOnWriteArraySet classLoaders = new CopyOnWriteArraySet();
    private HashSet dynamicClassLoaders = new HashSet();
    private HashMap nonUCLClassLoader = new HashMap();
    private HashSet classLoaderURLs = new HashSet();
    private ConcurrentReaderHashMap classes = new ConcurrentReaderHashMap();
    private HashMap loaderToClassesMap = new HashMap();
    private HashMap loaderToResourcesMap = new HashMap();
    private HashMap globalResources = new HashMap();
    private ConcurrentReaderHashMap packagesMap = new ConcurrentReaderHashMap();
    private HashMap loaderToPackagesMap = new HashMap();
    private long sequenceNumber = 0L;
    private final JBossNotificationBroadcasterSupport broadcaster = new JBossNotificationBroadcasterSupport();
    private MBeanNotificationInfo[] info;

    public RepositoryClassLoader newClassLoader(URL url, boolean addToRepository) throws Exception {
        UnifiedClassLoader3 ucl = new UnifiedClassLoader3(url, null, this);
        if (addToRepository) {
            this.registerClassLoader(ucl);
        }
        return ucl;
    }

    public RepositoryClassLoader newClassLoader(URL url, URL origURL, boolean addToRepository) throws Exception {
        UnifiedClassLoader3 ucl = new UnifiedClassLoader3(url, origURL, this);
        if (addToRepository) {
            this.registerClassLoader(ucl);
        }
        return ucl;
    }

    public int getCacheSize() {
        return this.classes.size();
    }

    public int getClassLoadersSize() {
        return this.classLoaders.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ConcurrentReaderHashMap concurrentReaderHashMap = this.classes;
        synchronized (concurrentReaderHashMap) {
            this.classes.clear();
        }
    }

    public Class getCachedClass(String classname) {
        return (Class)this.classes.get(classname);
    }

    public Class loadClass(String name, boolean resolve, ClassLoader cl) throws ClassNotFoundException {
        RepositoryClassLoader rcl = this.getRepositoryClassLoader(cl, name);
        return rcl.loadClass(name, resolve);
    }

    public Set getPackageClassLoaders(String className) {
        String pkgName = ClassLoaderUtils.getPackageName(className);
        if (pkgName.startsWith("java.")) {
            return null;
        }
        Set pkgSet = (Set)this.packagesMap.get(pkgName);
        if (this.dynamicClassLoaders.size() > 0) {
            if (pkgSet == null) {
                pkgSet = ClassLoaderUtils.newPackageSet();
            }
            pkgSet.addAll(this.dynamicClassLoaders);
        }
        return pkgSet;
    }

    private String getResourcePackageName(String rsrcName) {
        int index = rsrcName.lastIndexOf(47);
        String pkgName = rsrcName;
        if (index > 0) {
            pkgName = rsrcName.substring(0, index);
        }
        return pkgName.replace('/', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClassFromCache(String name) {
        Class cls = null;
        ConcurrentReaderHashMap concurrentReaderHashMap = this.classes;
        synchronized (concurrentReaderHashMap) {
            cls = (Class)this.classes.get(name);
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheLoadedClass(String name, Class cls, ClassLoader cl) {
        ConcurrentReaderHashMap concurrentReaderHashMap = this.classes;
        synchronized (concurrentReaderHashMap) {
            HashSet<String> loadedClasses;
            Object prevClass = this.classes.put(name, cls);
            if (log.isTraceEnabled()) {
                log.trace("cacheLoadedClass, classname: " + name + ", class: " + cls + ", ucl: " + cl + ", prevClass: " + prevClass);
            }
            if ((loadedClasses = (HashSet<String>)this.loaderToClassesMap.get(cl)) == null) {
                loadedClasses = new HashSet<String>();
                this.loaderToClassesMap.put(cl, loadedClasses);
            }
            loadedClasses.add(name);
        }
    }

    Class loadClassFromClassLoader(String name, boolean resolve, RepositoryClassLoader cl) {
        try {
            Class cls = cl.loadClassLocally(name, resolve);
            this.cacheLoadedClass(name, cls, cl);
            return cls;
        }
        catch (ClassNotFoundException x) {
            return null;
        }
    }

    public URL getResource(String name, ClassLoader cl) {
        URL resource = this.getResourceFromCache(name, cl);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromClassLoader(name, cl);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromGlobalCache(name);
        if (resource != null) {
            return resource;
        }
        resource = this.getResourceFromRepository(name, cl);
        if (resource != null) {
            return resource;
        }
        return null;
    }

    public void getResources(String name, ClassLoader cl, List urls) {
        for (ClassLoader nextCL : this.classLoaders) {
            if (!(nextCL instanceof RepositoryClassLoader)) continue;
            RepositoryClassLoader ucl = (RepositoryClassLoader)nextCL;
            try {
                Enumeration resURLs = ucl.findResourcesLocally(name);
                while (resURLs.hasMoreElements()) {
                    Object res = resURLs.nextElement();
                    urls.add(res);
                }
            }
            catch (IOException ignore) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getResourceFromCache(String name, ClassLoader cl) {
        URL resource = null;
        HashMap hashMap = this.loaderToResourcesMap;
        synchronized (hashMap) {
            if (this.loaderToResourcesMap.containsKey(cl)) {
                HashMap resources = (HashMap)this.loaderToResourcesMap.get(cl);
                resource = (URL)resources.get(name);
            }
        }
        return resource;
    }

    private URL getResourceFromClassLoader(String name, ClassLoader cl) {
        URL resource = null;
        if (cl instanceof RepositoryClassLoader) {
            RepositoryClassLoader ucl = (RepositoryClassLoader)cl;
            resource = ucl.getResourceLocally(name);
            this.cacheLoadedResource(name, resource, cl);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL getResourceFromGlobalCache(String name) {
        ResourceInfo ri = null;
        HashMap hashMap = this.loaderToResourcesMap;
        synchronized (hashMap) {
            ri = (ResourceInfo)this.globalResources.get(name);
        }
        URL resource = null;
        if (ri != null) {
            resource = ri.url;
        }
        return resource;
    }

    protected URL getResourceFromRepository(String name, ClassLoader cl) {
        String pkgName = this.getResourcePackageName(name);
        Iterator i = null;
        Set pkgSet = (Set)this.packagesMap.get(pkgName);
        if (pkgSet != null) {
            i = pkgSet.iterator();
        }
        if (i == null) {
            i = this.classLoaders.iterator();
        }
        URL url = null;
        while (i.hasNext()) {
            ClassLoader classloader = (ClassLoader)i.next();
            if (classloader.equals(cl) || !(classloader instanceof RepositoryClassLoader) || (url = ((RepositoryClassLoader)classloader).getResourceLocally(name)) == null) continue;
            this.cacheLoadedResource(name, url, classloader);
            this.cacheGlobalResource(name, url, classloader);
            break;
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheLoadedResource(String name, URL url, ClassLoader cl) {
        HashMap hashMap = this.loaderToResourcesMap;
        synchronized (hashMap) {
            HashMap<String, URL> resources = (HashMap<String, URL>)this.loaderToResourcesMap.get(cl);
            if (resources == null) {
                resources = new HashMap<String, URL>();
                this.loaderToResourcesMap.put(cl, resources);
            }
            resources.put(name, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheGlobalResource(String name, URL url, ClassLoader cl) {
        HashMap hashMap = this.loaderToResourcesMap;
        synchronized (hashMap) {
            this.globalResources.put(name, new ResourceInfo(url, cl));
        }
    }

    public URL[] getURLs() {
        HashSet<URL> classpath = new HashSet<URL>();
        CopyOnWriteArraySet tmp = this.classLoaders;
        for (Object obj : tmp) {
            if (!(obj instanceof RepositoryClassLoader)) continue;
            RepositoryClassLoader cl = (RepositoryClassLoader)obj;
            URL[] urls = cl.getClasspath();
            int length = urls != null ? urls.length : 0;
            for (int u = 0; u < length; ++u) {
                URL path = urls[u];
                classpath.add(path);
            }
        }
        URL[] cp = new URL[classpath.size()];
        classpath.toArray(cp);
        return cp;
    }

    public String displayClassInfo(String className) {
        String classRsrcName = className.replace('.', '/') + ".class";
        int count = 0;
        Class loadedClass = this.loadClassFromCache(className);
        StringBuffer results = new StringBuffer(className + " Information\n");
        if (loadedClass != null) {
            results.append("Repository cache version:");
            ClassLoaderUtils.displayClassInfo(loadedClass, results);
        } else {
            results.append("Not loaded in repository cache\n");
        }
        CopyOnWriteArraySet tmp = this.classLoaders;
        for (URLClassLoader cl : tmp) {
            URL classURL = cl.findResource(classRsrcName);
            if (classURL == null) continue;
            results.append("\n\n### Instance" + count + " found in UCL: " + cl + "\n");
            ++count;
        }
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        URLClassLoader[] stack = ClassLoaderUtils.getClassLoaderStack(tcl);
        for (int s = 0; s < stack.length; ++s) {
            URLClassLoader cl = stack[s];
            URL classURL = cl.findResource(classRsrcName);
            if (classURL == null) continue;
            results.append("\n\n### Instance" + count + " via UCL: " + cl + "\n");
            ++count;
        }
        return results.toString();
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        ClassLoader scl = Thread.currentThread().getContextClassLoader();
        ClassLoader ucl = null;
        if (this.classLoaders.size() > 0) {
            ucl = (ClassLoader)this.classLoaders.iterator().next();
        }
        try {
            if (ucl != null) {
                return this.loadClass(className, false, ucl);
            }
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        try {
            return scl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            Class clazz = UnifiedLoaderRepository3.getNativeClassForName(className);
            if (clazz != null) {
                return clazz;
            }
            throw new ClassNotFoundException(className);
        }
    }

    public Class loadClassWithout(ClassLoader loader, String className) throws ClassNotFoundException {
        throw new ClassNotFoundException("NYI");
    }

    public Class loadClassBefore(ClassLoader stop, String className) throws ClassNotFoundException {
        RepositoryClassLoader stopAt = this.getRepositoryClassLoader(stop, className);
        return stopAt.loadClassBefore(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryClassLoader getWrappingClassLoader(ClassLoader cl) {
        CopyOnWriteArraySet copyOnWriteArraySet = this.classLoaders;
        synchronized (copyOnWriteArraySet) {
            return (RepositoryClassLoader)this.nonUCLClassLoader.get(cl);
        }
    }

    public void addClassLoader(ClassLoader loader) {
        if (loader instanceof RepositoryClassLoader) {
            this.addRepositoryClassLoader((RepositoryClassLoader)loader);
        } else if (loader instanceof MLet) {
            this.addMLetClassLoader((MLet)loader);
        } else if (loader instanceof URLClassLoader) {
            this.addURLClassLoader((URLClassLoader)loader);
        } else {
            log.warn("Tried to add non-URLClassLoader.  Ignored");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addClassLoaderURL(ClassLoader cl, URL url) {
        RepositoryClassLoader ucl = (RepositoryClassLoader)cl;
        boolean added = false;
        CopyOnWriteArraySet copyOnWriteArraySet = this.classLoaders;
        synchronized (copyOnWriteArraySet) {
            String query = url.getQuery();
            if (query != null) {
                String ext = url.toExternalForm();
                String ext2 = ext.substring(0, ext.length() - query.length() - 1);
                try {
                    url = new URL(ext2);
                }
                catch (MalformedURLException e) {
                    log.warn("Failed to strip query from: " + url, e);
                }
            }
            if (!this.classLoaderURLs.contains(url)) {
                this.updatePackageMap(ucl, url);
                this.classLoaderURLs.add(url);
                added = true;
                if (query != null && query.indexOf("dynamic=true") >= 0) {
                    this.dynamicClassLoaders.add(ucl);
                }
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRepositoryClassLoader(RepositoryClassLoader cl) {
        cl.setRepository(this);
        URL url = cl.getURL();
        boolean added = false;
        CopyOnWriteArraySet copyOnWriteArraySet = this.classLoaders;
        synchronized (copyOnWriteArraySet) {
            boolean exists = false;
            if (cl instanceof UnifiedClassLoader) {
                exists = this.classLoaderURLs.contains(url);
            }
            if (!exists) {
                if (url != null) {
                    this.classLoaderURLs.add(url);
                }
                added = this.classLoaders.add(cl);
            }
            if (added) {
                log.debug("Adding " + cl);
                cl.setAddedOrder(++addedCount);
                this.updatePackageMap(cl);
            } else {
                log.debug("Skipping duplicate " + cl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMLetClassLoader(MLet loader) {
        MLetRepositoryClassLoader rcl = new MLetRepositoryClassLoader(loader);
        CopyOnWriteArraySet copyOnWriteArraySet = this.classLoaders;
        synchronized (copyOnWriteArraySet) {
            this.nonUCLClassLoader.put(loader, rcl);
        }
        this.addRepositoryClassLoader(rcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addURLClassLoader(URLClassLoader loader) {
        URL[] urls = loader.getURLs();
        int count = urls != null && urls.length > 0 ? urls.length : 0;
        URL origURL = count > 0 ? urls[0] : null;
        UnifiedClassLoader3 ucl3 = new UnifiedClassLoader3(origURL, origURL, this);
        this.addRepositoryClassLoader(ucl3);
        CopyOnWriteArraySet copyOnWriteArraySet = this.classLoaders;
        synchronized (copyOnWriteArraySet) {
            this.nonUCLClassLoader.put(loader, ucl3);
        }
        for (int i = 1; i < count; ++i) {
            this.addClassLoaderURL(ucl3, urls[i]);
        }
    }

    private void updatePackageMap(RepositoryClassLoader cl) {
        try {
            String[] pkgNames = ClassLoaderUtils.updatePackageMap(cl, this.packagesMap);
            this.loaderToPackagesMap.put(cl, pkgNames);
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Failed to update pkgs for cl=" + cl, e);
            }
            log.debug("Failed to update pkgs for cl=" + cl, e);
        }
    }

    private void updatePackageMap(RepositoryClassLoader cl, URL url) {
        try {
            String[] prevPkgNames = (String[])this.loaderToPackagesMap.get(cl);
            String[] pkgNames = ClassLoaderUtils.updatePackageMap(cl, (Map)this.packagesMap, url, prevPkgNames);
            this.loaderToPackagesMap.put(cl, pkgNames);
        }
        catch (Exception e) {
            if (log.isTraceEnabled()) {
                log.trace("Failed to update pkgs for cl=" + cl, e);
            }
            log.debug("Failed to update pkgs for cl=" + cl, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassLoader(ClassLoader loader) {
        ArrayList<Notification> removeNotifications = new ArrayList<Notification>();
        ClassLoader cl = loader;
        CopyOnWriteArraySet copyOnWriteArraySet = this.classLoaders;
        synchronized (copyOnWriteArraySet) {
            if (!(loader instanceof RepositoryClassLoader)) {
                cl = (ClassLoader)this.nonUCLClassLoader.remove(loader);
            }
            if (cl instanceof RepositoryClassLoader) {
                RepositoryClassLoader ucl = (RepositoryClassLoader)cl;
                if (this.getTranslator() != null) {
                    this.getTranslator().unregisterClassLoader(ucl);
                }
                URL[] urls = ucl.getClasspath();
                for (int u = 0; u < urls.length; ++u) {
                    this.classLoaderURLs.remove(urls[u]);
                }
            }
            boolean dynamic = this.dynamicClassLoaders.remove(cl);
            boolean removed = this.classLoaders.remove(cl);
            log.debug("UnifiedLoaderRepository removed(" + removed + ") " + cl);
            HashSet loadedClasses = null;
            boolean hasLoadedClasses = false;
            AbstractMap abstractMap = this.classes;
            synchronized (abstractMap) {
                hasLoadedClasses = this.loaderToClassesMap.containsKey(cl);
                if (hasLoadedClasses) {
                    loadedClasses = (HashSet)this.loaderToClassesMap.remove(cl);
                }
                if (loadedClasses != null) {
                    for (String className : loadedClasses) {
                        Notification n = new Notification("jboss.mx.class.removed", (Object)this, this.getNextSequenceNumber(), className);
                        removeNotifications.add(n);
                    }
                    for (String cls : loadedClasses) {
                        this.classes.remove(cls);
                    }
                }
            }
            abstractMap = this.loaderToResourcesMap;
            synchronized (abstractMap) {
                HashMap resources;
                if (this.loaderToResourcesMap.containsKey(cl) && (resources = (HashMap)this.loaderToResourcesMap.remove(cl)) != null) {
                    for (String name : resources.keySet()) {
                        ResourceInfo ri = (ResourceInfo)this.globalResources.get(name);
                        if (ri == null || ri.cl != cl) continue;
                        this.globalResources.remove(name);
                    }
                }
            }
            if (!dynamic) {
                String[] pkgNames = (String[])this.loaderToPackagesMap.remove(cl);
                int length = pkgNames != null ? pkgNames.length : 0;
                for (int p = 0; p < length; ++p) {
                    String pkgName = pkgNames[p];
                    Set pkgSet = (Set)this.packagesMap.get(pkgName);
                    if (pkgSet == null) continue;
                    pkgSet.remove(cl);
                    if (!pkgSet.isEmpty()) continue;
                    this.packagesMap.remove(pkgName);
                }
            } else {
                this.loaderToPackagesMap.remove(cl);
                Iterator i = this.packagesMap.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = (Map.Entry)i.next();
                    Set pkgSet = (Set)entry.getValue();
                    pkgSet.remove(cl);
                    if (!pkgSet.isEmpty()) continue;
                    i.remove();
                }
            }
        }
        for (int n = 0; n < removeNotifications.size(); ++n) {
            Notification msg = (Notification)removeNotifications.get(n);
            this.broadcaster.sendNotification(msg);
        }
        if (NOTIFICATION_MODE == 0 || NOTIFICATION_MODE == 1) {
            Notification msg = new Notification("jboss.mx.classloader.removed", this, this.getNextSequenceNumber());
            if (NOTIFICATION_MODE == 1) {
                msg.setUserData(new WeakReference<ClassLoader>(cl));
            } else {
                msg.setUserData(cl);
            }
            this.broadcaster.sendNotification(msg);
        }
    }

    public LoaderRepository registerClassLoader(RepositoryClassLoader ucl) {
        this.addClassLoader(ucl);
        if (NOTIFICATION_MODE == 0 || NOTIFICATION_MODE == 1) {
            Notification msg = new Notification("jboss.mx.classloader.added", this, this.getNextSequenceNumber());
            if (NOTIFICATION_MODE == 1) {
                msg.setUserData(new WeakReference<RepositoryClassLoader>(ucl));
            } else {
                msg.setUserData(ucl);
            }
            this.broadcaster.sendNotification(msg);
        }
        return this;
    }

    public LoaderRepository getInstance() {
        return this;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.info == null) {
            this.info = NOTIFICATION_MODE != 2 ? new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"CLASSLOADER_ADDED"}, "javax.management.Notification", "Notification that a classloader has been added to the extensible classloader"), new MBeanNotificationInfo(new String[]{"CLASS_REMOVED"}, "javax.management.Notification", "Notification that a class has been removed from the extensible classloader")} : new MBeanNotificationInfo[0];
        }
        return this.info;
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener, filter, handback);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
        log.debug("postDeregister, clearing all references");
        this.classLoaders.clear();
        this.dynamicClassLoaders.clear();
        this.nonUCLClassLoader.clear();
        this.classLoaderURLs.clear();
        this.classes.clear();
        this.loaderToClassesMap.clear();
        this.loaderToResourcesMap.clear();
        this.globalResources.clear();
        this.packagesMap.clear();
        this.loaderToPackagesMap.clear();
    }

    private synchronized long getNextSequenceNumber() {
        return this.sequenceNumber++;
    }

    private RepositoryClassLoader getRepositoryClassLoader(ClassLoader cl, String name) throws ClassNotFoundException {
        if (cl instanceof RepositoryClassLoader) {
            return (RepositoryClassLoader)cl;
        }
        RepositoryClassLoader rcl = this.getWrappingClassLoader(cl);
        if (rcl == null) {
            throw new ClassNotFoundException("Class not found " + name + " (Unknown classloader " + cl + ")");
        }
        return rcl;
    }

    static {
        String value = ClassToStringAction.getProperty("org.jboss.mx.loading.UnifiedLoaderRepository.notifyMode", "0");
        NOTIFICATION_MODE = Integer.valueOf(value);
        switch (NOTIFICATION_MODE) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                log.warn("Invalid org.jboss.mx.loading.UnifiedLoaderRepository.notifyMode(" + value + "), defaulting to LEGACY_MODE");
                NOTIFICATION_MODE = 0;
            }
        }
    }
}

