/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.filterfactory;

import javax.management.NotificationFilter;
import javax.management.ObjectName;
import javax.management.relation.MBeanServerNotificationFilter;
import org.jboss.system.NotificationFilterFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MBeanServerNotificationFilterFactory
implements NotificationFilterFactory {
    public static final String ENABLE_ELEMENT = "enable";
    public static final String ENABLE_TYPE_ATTRIBUTE = "type";
    public static final String ENABLE_OBJECTNAME_ATTRIBUTE = "object-name";

    public NotificationFilter createNotificationFilter(Element filterConfig) throws Exception {
        MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
        NodeList filterChildren = filterConfig.getChildNodes();
        for (int i = 0; i < filterChildren.getLength(); ++i) {
            Node filterChildNode = filterChildren.item(i);
            if (!filterChildNode.getNodeName().equals(ENABLE_ELEMENT)) continue;
            if (((Element)filterChildNode).hasAttribute(ENABLE_TYPE_ATTRIBUTE)) {
                String type = ((Element)filterChildNode).getAttribute(ENABLE_TYPE_ATTRIBUTE);
                filter.enableType(type);
                continue;
            }
            if (((Element)filterChildNode).hasAttribute(ENABLE_OBJECTNAME_ATTRIBUTE)) {
                String objectName = ((Element)filterChildNode).getAttribute(ENABLE_OBJECTNAME_ATTRIBUTE);
                filter.enableObjectName(new ObjectName(objectName));
                continue;
            }
            throw new Exception("'enable' element must have a 'type' or a 'object-name' attribute");
        }
        return filter;
    }
}

