/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import java.net.SocketException;
import java.sql.SQLException;
import org.postgresforest.Driver;
import org.postgresforest.core.ParameterList;
import org.postgresforest.core.Query;
import org.postgresforest.core.QueryExecutor;
import org.postgresforest.jdbc2.AbstractJdbc2Connection;
import org.postgresforest.util.GT;
import org.postgresforest.util.PSQLException;
import org.postgresforest.vm.AbstractForestThread;
import org.postgresforest.vm.Lock;
import org.postgresforest.vm.MetaDataReWriter;
import org.postgresforest.vm.QueryInfo;
import org.postgresforest.vm.ReWriter;
import org.postgresforest.vm.StatementExecuteSub;
import org.postgresforest.vm.StatementThreadMng;
import org.postgresforest.vm.core.QueryExecutorImpl;
import org.postgresforest.vm.core.SimpleParameterList;
import org.postgresforest.vm.core.SimpleQuery;
import org.postgresforest.vm.core.SimpleResultHandler;
import org.postgresforest.vm.err.ForestSQLState;
import org.postgresforest.vm.gsc.GscData;

public class StatementSub
extends AbstractForestThread {
    public static final int STAT_OK = 0;
    public static final int STAT_NG = -1;
    protected AbstractJdbc2Connection m_con;
    protected String m_sql;
    protected QueryInfo m_qi;
    protected GscData m_gsc;
    protected ReWriter m_rw;
    public SQLException m_errObj;
    public int m_errCode = 0;
    public int m_retry = 0;
    protected StatementThreadMng m_threadMng;
    protected boolean m_selfClose;
    protected boolean m_serverBrokenChk;
    protected StatementExecuteSub m_ses;
    protected Lock m_lock;
    protected QueryExecutorImpl m_queryExecutor;
    protected SimpleQuery m_query;
    protected SimpleParameterList m_parameters;
    protected int m_maxRows;
    protected int m_fetchSize;
    protected int m_flags;
    protected boolean m_metadata;
    static int id = 0;
    private int m_retryCount;

    public StatementSub(StatementThreadMng mng) {
        super(mng.getLogUtil());
        if (Driver.logInfo) {
            this.setName("StmSub" + id++);
        }
        this.m_ses = new StatementExecuteSub(this.getName());
        this.m_threadMng = mng;
    }

    public void execute(SimpleQuery query, SimpleParameterList parameterList, int maxRows, int fetchSize, int flags, QueryExecutorImpl queryExecutor, QueryInfo srcQueryInfo, ReWriter srcRewriter, Lock lock) {
        this.m_query = query;
        this.m_parameters = parameterList;
        this.m_maxRows = maxRows;
        this.m_fetchSize = fetchSize;
        this.m_flags = flags;
        this.m_queryExecutor = queryExecutor;
        this.m_qi = srcQueryInfo;
        this.m_con = (AbstractJdbc2Connection)this.m_qi.getConnection();
        this.m_sql = this.m_qi.getSql();
        this.m_gsc = this.m_queryExecutor.getGsc();
        this.m_rw = srcRewriter;
        if (this.m_rw instanceof MetaDataReWriter) {
            this.m_retry = this.m_gsc.getServerCount();
            this.m_metadata = true;
        } else {
            this.m_retry = this.m_gsc.getRetry();
            this.m_metadata = false;
        }
        this.m_lock = lock;
        this.m_threadMng.setExecSeq(this.m_con, this);
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _execute() {
        boolean flg = true;
        this.m_errCode = 0;
        this.m_retryCount = 0;
        boolean noResults = (this.m_flags & 4) != 0;
        boolean noMeta = (this.m_flags & 2) != 0;
        boolean describeOnly = (this.m_flags & 0x20) != 0;
        boolean usePortal = (this.m_flags & 8) != 0 && !noResults && !noMeta && this.m_fetchSize > 0 && !describeOnly;
        boolean oneShot = (this.m_flags & 1) != 0 && !usePortal;
        try {
            try {
                while (flg) {
                    Query query;
                    this.m_threadMng.waitExecSeq(this.m_con, this);
                    if (Driver.forestTestLog) {
                        System.out.println("SQL:" + this.m_sql + "\nURL:" + this.m_con.getURL() + '\n');
                    }
                    if (Driver.logInfo) {
                        this.m_logUtil.info(this.getName() + ": Execute Query = " + this.m_sql);
                        this.m_logUtil.info(this.getName() + ": Execute Connection = " + this.m_con.getURL());
                    }
                    QueryExecutor queryExecutor = this.m_con.getQueryExecutor();
                    if (oneShot) {
                        query = this.m_parameters == null ? queryExecutor.createSimpleQuery(this.m_sql) : queryExecutor.createParameterizedQuery(this.m_sql);
                    } else {
                        query = this.m_query.getPreparedQuery(this.m_con, this.m_sql);
                        if (query == null) {
                            query = this.m_parameters == null ? queryExecutor.createSimpleQuery(this.m_sql) : queryExecutor.createParameterizedQuery(this.m_sql);
                            this.m_query.putPreparedQuery(this.m_con, this.m_sql, query);
                        }
                    }
                    ParameterList preparedParameters = null;
                    if (this.m_parameters != null) {
                        preparedParameters = this.m_parameters.copyTo(query.createParameterList());
                    }
                    int timeout = this.m_gsc.getTimeout();
                    if (this.m_query.getTimeout() != 0) {
                        timeout = this.m_query.getTimeout();
                    }
                    if (timeout != 0) {
                        queryExecutor.getPGStream().getSocket().setSoTimeout(timeout * 1000);
                    } else {
                        queryExecutor.getPGStream().getSocket().setSoTimeout(0);
                    }
                    this.m_ses.execute(queryExecutor, query, preparedParameters, this.m_maxRows, this.m_fetchSize, this.m_flags);
                    if (this.m_metadata) {
                        flg = this.excutedMetaData();
                        continue;
                    }
                    flg = this.excuted();
                }
                Object var12_13 = null;
                this.m_threadMng.endExecSeq(this.m_con, this);
                this.m_lock.notifyEnd();
            }
            catch (SQLException esql) {
                this.m_errObj = esql;
                this.m_errCode = -1;
                Object var12_14 = null;
                this.m_threadMng.endExecSeq(this.m_con, this);
                this.m_lock.notifyEnd();
            }
            catch (SocketException e) {
                this.m_errObj = new PSQLException(GT.tr("excute internal error.\n{0}", e), ForestSQLState.INTERNAL_ERROR, (Throwable)e);
                this.m_errCode = -1;
                Object var12_15 = null;
                this.m_threadMng.endExecSeq(this.m_con, this);
                this.m_lock.notifyEnd();
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            this.m_threadMng.endExecSeq(this.m_con, this);
            this.m_lock.notifyEnd();
            throw throwable;
        }
        if (Driver.logDebug) {
            this.m_logUtil.debug(this.getName() + ": _execute() End");
        }
    }

    protected boolean excuted() throws SQLException {
        boolean flg = false;
        int sesStatus = this.m_ses.getErrCode();
        if (sesStatus == -3) {
            if (Driver.logInfo) {
                this.m_logUtil.info(this.getName() + ": The timeout occurred in execution of a query.");
            }
            this.m_gsc.setServerBroken(this.m_con, this.m_sql, new PSQLException(GT.tr("The timeout of the query was carried out."), ForestSQLState.INTERNAL_ERROR));
            if (Driver.logInfo) {
                this.m_logUtil.info(this.getName() + ": The query execution thread was stopped.");
            }
            if (this.m_rw.getQueryType() == 2) {
                if (Driver.logInfo) {
                    this.m_logUtil.info(this.getName() + ": Execution of a query is not re-tried for parallel processing.");
                }
                flg = false;
                this.m_errObj = new PSQLException(GT.tr("The timeout of the query was carried out."), ForestSQLState.INTERNAL_ERROR);
                this.m_errCode = -1;
            } else if (this.m_retry <= this.m_retryCount) {
                if (Driver.logInfo) {
                    this.m_logUtil.info(this.getName() + ": Since the number of times of re-trial was exceeded, it is made an error, without re-trying.");
                }
                flg = false;
                this.m_errObj = new PSQLException(GT.tr("Error retry over."), ForestSQLState.INTERNAL_ERROR);
                this.m_errCode = -1;
            } else {
                if (Driver.logInfo) {
                    this.m_logUtil.info(this.getName() + ": Execution of a query is re-tried.");
                }
                this.m_threadMng.endExecSeq(this.m_con, this);
                this.m_con = (AbstractJdbc2Connection)this.m_rw.getRetryConnection(this.m_qi);
                this.m_threadMng.setExecSeq(this.m_con, this);
                flg = true;
                ++this.m_retryCount;
            }
        } else if (sesStatus == 0) {
            if (Driver.logInfo) {
                this.m_logUtil.info(this.getName() + ": Execution of a query was ended normally.");
            }
            flg = false;
        } else if (sesStatus == -1 || sesStatus == -4 && this.m_queryExecutor.getAutocommit()) {
            if (Driver.logInfo) {
                this.m_logUtil.info(this.getName() + ": The error for server separation occurred.");
            }
            this.m_gsc.setServerBroken(this.m_con, this.m_sql, this.m_ses.getErrobj());
            if (this.m_rw.getQueryType() == 2) {
                if (Driver.logInfo) {
                    this.m_logUtil.info(this.getName() + ": Execution of a query is not re-tried for parallel processing.");
                }
                this.m_errObj = this.m_ses.getErrobj();
                this.m_errCode = -1;
                flg = false;
            } else if (this.m_retry <= this.m_retryCount) {
                if (Driver.logInfo) {
                    this.m_logUtil.info(this.getName() + ": Since the number of times of re-trial was exceeded, it is made an error, without re-trying.");
                }
                this.m_errObj = new PSQLException(GT.tr("Error retry over."), ForestSQLState.INTERNAL_ERROR);
                this.m_errCode = -1;
                flg = false;
            } else {
                if (Driver.logInfo) {
                    this.m_logUtil.info(this.getName() + ": Execution of a query is re-tried.");
                }
                this.m_threadMng.endExecSeq(this.m_con, this);
                this.m_con = (AbstractJdbc2Connection)this.m_rw.getRetryConnection(this.m_qi);
                this.m_threadMng.setExecSeq(this.m_con, this);
                flg = true;
                ++this.m_retryCount;
            }
        } else if (sesStatus == -2) {
            if (Driver.logInfo) {
                this.m_logUtil.info(this.getName() + ": The error which is not a candidate for server separation occurred.");
            }
            flg = false;
            this.m_errObj = this.m_ses.getErrobj();
            this.m_errCode = -1;
        } else if (sesStatus == -4) {
            if (Driver.logInfo) {
                this.m_logUtil.info(this.getName() + ": Rollback object error generation.");
            }
            flg = false;
            this.m_errObj = this.m_ses.getErrobj();
            this.m_errCode = -1;
            this.m_queryExecutor.setRollback(this.m_errObj);
        }
        return flg;
    }

    protected boolean excutedMetaData() throws SQLException {
        boolean flg = true;
        int sesStatus = this.m_ses.getErrCode();
        if (sesStatus == 0) {
            if (Driver.logInfo) {
                this.m_logUtil.info(this.getName() + ": Execution of a query was ended normally.");
            }
            if (this.getResultHandler().getTuples().size() != 0) {
                flg = false;
            }
        }
        if (flg) {
            if (Driver.logInfo && sesStatus == -3) {
                this.m_logUtil.info(this.getName() + ": The timeout occurred in execution of a query.");
            }
            if (this.m_retry <= this.m_retryCount) {
                flg = false;
            } else {
                if (Driver.logInfo) {
                    this.m_logUtil.info(this.getName() + ": Execution of a query is re-tried.");
                }
                this.m_threadMng.endExecSeq(this.m_con, this);
                this.m_con = (AbstractJdbc2Connection)this.m_rw.getRetryConnection(this.m_qi);
                this.m_threadMng.setExecSeq(this.m_con, this);
                ++this.m_retryCount;
            }
        }
        return flg;
    }

    public void terminate() {
        if (Driver.logDebug) {
            this.m_logUtil.debug(this.getName() + ": terminate() In");
        }
        super.terminate();
        if (Driver.logDebug) {
            this.m_logUtil.debug(this.getName() + ": terminate() Out");
        }
    }

    public void setSelfClose(boolean b) {
        this.m_selfClose = b;
    }

    public void close() {
        if (Driver.logDebug) {
            this.m_logUtil.debug(this.getName() + ": The separation check of a server is started.");
        }
        boolean brokenChk = this.m_serverBrokenChk;
        this.setServerBrokenChk(false);
        if (brokenChk && this.m_rw.getQueryType() == 2 && this.m_errCode == -1) {
            if (this.m_queryExecutor.isRollback()) {
                return;
            }
            if (Driver.logInfo) {
                this.m_logUtil.info(this.getName() + ": There is a server for separation.");
            }
            try {
                this.m_gsc.setServerBroken(this.m_con, this.m_sql, this.m_ses.getErrobj());
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (Driver.logDebug) {
            this.m_logUtil.debug(this.getName() + ": The separation check of a server is ended.");
        }
    }

    public void setServerBrokenChk(boolean b) {
        this.m_serverBrokenChk = b;
    }

    protected void standby() {
        super.standby();
        if (this.m_selfClose) {
            this.m_threadMng.closeStatementSub(this);
        }
        this.m_selfClose = false;
    }

    public int getErrCode() {
        return this.m_errCode;
    }

    public SimpleResultHandler getResultHandler() {
        return this.m_ses.getResultHandler();
    }

    public SQLException getErrObj() {
        return this.m_errObj;
    }

    public String getURL() throws SQLException {
        return this.m_con.getURL();
    }

    public String getSql() {
        return this.m_sql;
    }
}

