/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.postgresforest.Driver;
import org.postgresforest.jdbc2.AbstractJdbc2Connection;
import org.postgresforest.vm.LogUtil;
import org.postgresforest.vm.StatementSub;

public class StatementThreadMng {
    protected int m_max;
    protected LinkedList available = new LinkedList();
    protected HashMap m_execSeqMap = new HashMap();
    protected int used;
    protected LogUtil m_logUtil;

    public StatementThreadMng(int threadNum) {
        this.m_max = threadNum;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized StatementSub getStatementSub() {
        void var1_2;
        while (true) {
            StatementSub thread;
            if (this.available.size() > 0) {
                thread = (StatementSub)this.available.removeFirst();
                ++this.used;
                break;
            }
            if (this.m_max == 0 || this.used < this.m_max) {
                thread = new StatementSub(this);
                ++this.used;
                break;
            }
            if (Driver.logInfo) {
                this.m_logUtil.info("There is no empty thread. It stands by.");
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.notify();
        if (Driver.logInfo) {
            this.m_logUtil.info(var1_2.getName() + ": The thread was secured. ");
        }
        return var1_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeStatementSub(StatementSub thread) {
        if (Driver.logDebug) {
            this.m_logUtil.debug(thread.getName() + ": closeStatementSub() In");
        }
        StatementSub statementSub = thread;
        synchronized (statementSub) {
            if (thread.isExecuted()) {
                thread.close();
                --this.used;
                this.available.addFirst(thread);
                this.notify();
                if (Driver.logInfo) {
                    this.m_logUtil.info(thread.getName() + ": The thread was opened wide.");
                }
            } else {
                thread.setSelfClose(true);
                if (Driver.logInfo) {
                    this.m_logUtil.info(thread.getName() + ": Opening of a thread was reserved.");
                }
            }
        }
        if (Driver.logDebug) {
            this.m_logUtil.debug(thread.getName() + ": closeStatementSub() Out");
        }
    }

    public synchronized void terminate() {
        if (Driver.logDebug) {
            this.m_logUtil.debug("StatementThreadMng: terminate() Ready");
        }
        while (this.used > 0) {
            try {
                if (Driver.logDebug) {
                    this.m_logUtil.debug("StatementThreadMng: terminate() Wait");
                }
                this.wait();
            }
            catch (InterruptedException e) {}
        }
        if (Driver.logDebug) {
            this.m_logUtil.debug("StatementThreadMng: terminate() Terminate Available");
        }
        Iterator iter = this.available.iterator();
        while (iter.hasNext()) {
            StatementSub thread = (StatementSub)iter.next();
            thread.terminate();
        }
        if (Driver.logDebug) {
            this.m_logUtil.debug("StatementThreadMng: terminate() End");
        }
    }

    public synchronized void waitFree() {
        while (this.used != 0) {
            try {
                if (Driver.logDebug) {
                    Driver.debug("StatementThreadMng::waitFree() Waiting");
                }
                this.wait();
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void setLogUtil(LogUtil util) {
        this.m_logUtil = util;
    }

    public LogUtil getLogUtil() {
        return this.m_logUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExecSeq(Connection con, StatementSub thread) {
        HashMap hashMap = this.m_execSeqMap;
        synchronized (hashMap) {
            LinkedList<StatementSub> execSeq = (LinkedList<StatementSub>)this.m_execSeqMap.get(con);
            if (execSeq == null) {
                execSeq = new LinkedList<StatementSub>();
                execSeq.addLast(thread);
                this.m_execSeqMap.put(con, execSeq);
            } else {
                LinkedList<StatementSub> linkedList = execSeq;
                synchronized (linkedList) {
                    execSeq.addLast(thread);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endExecSeq(Connection con, StatementSub thread) {
        LinkedList execSeq;
        LinkedList linkedList = execSeq = (LinkedList)this.m_execSeqMap.get(con);
        synchronized (linkedList) {
            if (execSeq.isEmpty()) {
                return;
            }
            Object executing = execSeq.getFirst();
            if (thread.equals(executing)) {
                execSeq.removeFirst();
            }
            if (execSeq.size() > 0) {
                execSeq.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitExecSeq(Connection con, StatementSub thread) {
        LinkedList execSeq;
        LinkedList linkedList = execSeq = (LinkedList)this.m_execSeqMap.get(con);
        synchronized (linkedList) {
            while (execSeq.size() != 0) {
                if (thread.equals(execSeq.getFirst())) {
                    return;
                }
                if (Driver.forestTestLog) {
                    try {
                        System.out.println(thread.getName() + ":CON_SEQ_WAIT:" + ((AbstractJdbc2Connection)con).getURL());
                    }
                    catch (SQLException e1) {
                        // empty catch block
                    }
                }
                try {
                    execSeq.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

