/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.vm.core;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Timer;
import java.util.TimerTask;
import org.postgresforest.PGNotification;
import org.postgresforest.core.Encoding;
import org.postgresforest.core.ProtocolConnection;
import org.postgresforest.core.QueryExecutor;
import org.postgresforest.jdbc2.AbstractJdbc2Connection;
import org.postgresforest.vm.LogUtil;
import org.postgresforest.vm.StatementThreadMng;
import org.postgresforest.vm.core.QueryExecutorImpl;
import org.postgresforest.vm.gsc.GscData;

public class ProtocolConnectionImpl
implements ProtocolConnection {
    protected GscData m_gsc;
    protected StatementThreadMng m_threadMng;
    protected LogUtil m_logUtil;
    protected static Timer m_closeTimer = new Timer(true);
    private final String user;
    private final String database;
    private final QueryExecutorImpl executor;
    private final int m_protocolVersion;
    private final String m_serverVersion;
    protected Encoding m_encoding;
    protected int m_transactionState = 0;

    public ProtocolConnectionImpl(String database, GscData gsc, StatementThreadMng mng, String user) throws SQLException {
        this.database = database;
        this.m_gsc = gsc;
        this.m_threadMng = mng;
        this.m_logUtil = this.m_gsc.getLogUtil();
        this.user = user;
        this.executor = new QueryExecutorImpl(this.m_gsc, this.m_threadMng, this);
        AbstractJdbc2Connection con = (AbstractJdbc2Connection)this.m_gsc.getLastServer();
        this.m_protocolVersion = con.getProtocolVersion();
        this.m_serverVersion = con.getDBVersionNumber();
        this.m_encoding = con.getEncoding();
    }

    public String getHost() {
        return null;
    }

    public int getPort() {
        return 0;
    }

    public String getServerVersion() {
        return this.m_serverVersion;
    }

    public Encoding getEncoding() {
        return this.m_encoding;
    }

    public int getTransactionState() {
        return this.m_transactionState;
    }

    public PGNotification[] getNotifications() throws SQLException {
        return null;
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void sendQueryCancel() throws SQLException {
    }

    public void close() {
        if (!this.isClosed()) {
            this.m_gsc.setClosed(true);
            m_closeTimer.schedule((TimerTask)new CloseTask(), 0L);
        }
    }

    public int getProtocolVersion() {
        return this.m_protocolVersion;
    }

    public QueryExecutor getQueryExecutor() {
        return this.executor;
    }

    public String getUser() {
        return this.user;
    }

    public String getDatabase() {
        return this.database;
    }

    public boolean isClosed() {
        return this.m_gsc.isClosed();
    }

    public void setTransactionState(int transactionState) {
        this.m_transactionState = transactionState;
    }

    protected class CloseTask
    extends TimerTask {
        protected CloseTask() {
        }

        public void run() {
            ProtocolConnectionImpl.this.m_threadMng.terminate();
            ProtocolConnectionImpl.this.m_gsc.close();
        }
    }
}

