/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.bean;

import java.sql.Timestamp;

/**
 * 通知グループIDと通知IDとログ出力基本情報を保持するクラス<BR>
 *
 * @version 3.0.0
 * @since 3.0.0
 */
public class OutputNotifyGroupInfo extends OutputBasicInfo{
	
	private static final long serialVersionUID = -1379585389383805509L;
	
	private String m_notifyGroupId;	// 通知グループID
	private String m_notifyId; // 通知ID
	private Timestamp m_outputDate; // 受信日時

	/**
	 * 通知グループIDを返します。
	 * 
	 * @return 通知グループID
	 */
	public String getNotifyGroupId() {
		return m_notifyGroupId;
	}

	/**
	 * 通知グループIDを設定します。
	 * 
	 * @param id 通知グループID
	 */
	public void setNotifyGroupId(String id) {
		m_notifyGroupId = id;
	}
	
	/** 通知IDを返します。
	 * 
	 * @return 通知ID
	 */
	public String getNotifyId() {
		return m_notifyId;
	}
	
	/**
	 * 通知IDを設定します。
	 * 
	 * @param id 通知ID
	 */
	public void setNotifyId(String id) {
		m_notifyId = id;
	}

	/**
	 * 出力日時を取得します。
	 * 
	 * @return 出力日時
	 */
	public Timestamp getOutputDate() {
		return m_outputDate;
	}

	/**
	 * 出力日時を設定します。
	 * 
	 * @param date　出力日時
	 */
	public void setOutputDate(Timestamp date) {
		m_outputDate = date;
	}
}
