/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.util;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.calendar.ejb.session.CalendarController;
import com.clustercontrol.calendar.ejb.session.CalendarControllerHome;
import com.clustercontrol.util.LoginManager;

/**
 * EJBとのコネクションを管理するクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class EjbConnectionManager {
    private static EjbConnectionManager m_instance = null;
    private NamingContext m_ctx = null;

    /**
     * このオブジェクトを取得します。<BR>
     * 
     * @return ConnectionManager コネクションマネージャ
     */
    public static EjbConnectionManager getConnectionManager() {
        if (m_instance == null) {
            m_instance = new EjbConnectionManager();
        }
        return m_instance;
    }

    private EjbConnectionManager() {

    }

    /**
     * CalendarControllerを取得します。<BR>
     * 
     * @return CalendarController
     */
    public synchronized CalendarController getCalendarController() {
        try {
            m_ctx = LoginManager.getContextManager().getNamingContext();
        } catch (NamingException e) {
            return null;
        }

        CalendarControllerHome home;
        try {
            home = (CalendarControllerHome) m_ctx
                    .lookup(CalendarControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
}