/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.composite;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.clustercontrol.bean.FacilityTreeItem;

/**
 * スコープツリー用のコンテンツプロバイダクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class FacilityTreeContentProvider implements ITreeContentProvider {

    // ----- instance フィールド ----- //

    // ----- コンストラクタ ----- //

    // ----- instance メソッド ----- //

    public Object getParent(Object element) {
        return ((FacilityTreeItem) element).getParent();
    }

    public Object[] getElements(Object inputElement) {
        return getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        return ((FacilityTreeItem) parentElement).getChildren();
    }

    public boolean hasChildren(Object element) {
        return ((FacilityTreeItem) element).size() > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }
}