/*
 
Copyright (C) 2008 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.mail.util;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.jnp.interfaces.NamingContext;

import com.clustercontrol.notify.mail.ejb.session.MailTemplateController;
import com.clustercontrol.notify.mail.ejb.session.MailTemplateControllerHome;
import com.clustercontrol.util.LoginManager;


/**
 * EJBとのコネクションを管理するクラス<BR>
 * シングルトン。
 * 
 * @version 2.4.0
 * @since 2.4.0
 */
public class EjbConnectionManager {
	/** シングルトン用インスタンス。 */
    private static EjbConnectionManager m_instance = null;
    /** コンテキスト。 */
    private NamingContext m_ctx = null;

    /**
	 * 本クラスのインスタンスを返します。<BR>
	 * 
	 * シングルトン用インスタンスが<code> null </code>ならば、インスタンスを生成します。<BR>
	 * シングルトン用インスタンスが存在すれば、シングルトン用インスタンスを返します。
	 * 
	 * @return 唯一のインスタンス
	 */
    public static EjbConnectionManager getConnectionManager() {
        if (m_instance == null) {
            m_instance = new EjbConnectionManager();
        }
        return m_instance;
    }

    private EjbConnectionManager() {

    }

    /**
     * メールテンプレート機能 SessionBean のインスタンスを返します。<BR>
	 * 
	 * ログインマネージャにてコンテキストを取得し、
	 * メールテンプレート機能 SessionBean のインスタンスを取得します。
	 * 
	 * @return メールテンプレート機能 SessionBean
	 * @see com.clustercontrol.util.LoginManager
	 * @see com.clustercontrol.notify.mail.ejb.session.MailTemplateController
	 * @see com.clustercontrol.notify.mail.ejb.session.MailTemplateControllerHome
     */
    public synchronized MailTemplateController getMailTemplateController() {
        try {
            m_ctx = LoginManager.getContextManager().getNamingContext();
        } catch (NamingException e) {
            return null;
        }

        MailTemplateControllerHome home;
        try {
            home = (MailTemplateControllerHome) m_ctx
                    .lookup(MailTemplateControllerHome.JNDI_NAME);
            return home.create();
        } catch (NamingException e) {
        } catch (RemoteException e) {
        } catch (CreateException e) {
        }
        m_ctx = null;
        return null;
    }
}