/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * 一括制御機能プラグインクラスです
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CollectiveRunPlugin extends AbstractUIPlugin {

    // ----- static フィールド ----- //

    /** コンポジットアイコンの取得キー */
    public static final String IMG_COMPOSITE = "composite";
    
    /** コマンドツリーコンポジットアイコンの取得キー */
    public static final String IMG_COMMAND_COMPOSITE = "commandComposite";
    
    /** パラメータツリーコンポジットアイコンの取得キー */
    public static final String IMG_PARAMETER_COMPOSITE = "parameterComposite";

    /** 種別アイコンの取得キー */
    public static final String IMG_TYPE = "type";

    /** コマンドアイコンの取得キー */
    public static final String IMG_COMMAND = "command";
    
    /** パラメータアイコンの取得キー */
    public static final String IMG_PARAMETER = "parameter";
    
    /** 選択肢アイコンの取得キー */
    public static final String IMG_SELECT_ITEM = "selectItem";

    //	The shared instance.
    private static CollectiveRunPlugin plugin;

    // ----- instance フィールド----- //

    //	Resource bundle.
    private ResourceBundle resourceBundle;

    /**
     * コンストラクタ
     *  
     */
    public CollectiveRunPlugin() {
        super();
        plugin = this;
        try {
            resourceBundle = ResourceBundle
                    .getBundle("com.clustercontrol.collectiverun.CollectiveRunPluginResources");
        } catch (MissingResourceException x) {
            resourceBundle = null;
        }
    }

    /**
     * This method is called upon plug-in activation
     * 
     * @param context
     * @throws Exception
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    /**
     * This method is called when the plug-in is stopped
     * 
     * @param context
     * @throws Exception
     */
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    /**
     * Returns the shared instance.
     * 
     * @return plugin
     */
    public static CollectiveRunPlugin getDefault() {
        return plugin;
    }

    /**
     * Returns the string from the plugin's resource bundle, or 'key' if not
     * found.
     * 
     * @param key
     * @return key
     */
    public static String getResourceString(String key) {
        ResourceBundle bundle = CollectiveRunPlugin.getDefault()
                .getResourceBundle();
        try {
            return (bundle != null) ? bundle.getString(key) : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }

    /**
     * Returns the plugin's resource bundle,
     * 
     * @return resouceBundle
     */
    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    
    /**
     * プラグインクラスが保持するImageRegistryにイメージを登録します。
     * 
     * @param registry
     *            ImageRegistryオブジェクト
     */
    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerImage(registry, IMG_COMPOSITE, "composite.gif");
        this.registerImage(registry, IMG_COMMAND_COMPOSITE, "composite.gif");
        this.registerImage(registry, IMG_PARAMETER_COMPOSITE, "composite.gif");
        this.registerImage(registry, IMG_TYPE, "type.gif");
        this.registerImage(registry, IMG_COMMAND, "command.gif");
        this.registerImage(registry, IMG_PARAMETER, "parameter.gif");
        this.registerImage(registry, IMG_SELECT_ITEM, "select_item.gif");
    }

    /**
     * ImageRegistryにイメージを登録します。
     * 
     * @param registry
     *            ImageRegistryオブジェクト
     * @param key
     *            取得キー
     * @param fileName
     *            イメージファイル名
     */
    private void registerImage(ImageRegistry registry, String key,
            String fileName) {
        try {
            URL url = new URL(getDefault().getBundle().getEntry("/"), "icons/"
                    + fileName);
            ImageDescriptor desc = ImageDescriptor.createFromURL(url);
            registry.put(key, desc);
        } catch (Exception e) {
        }
    }
}