/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.composite;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

import com.clustercontrol.collectiverun.bean.TreeItem;

/**
 * TreeViewerクラス用のViewerSorterクラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class TreeViewerSorter extends ViewerSorter {

    /**
     * コンストラクタ
     * 
     * @param column
     *            ソート対象カラムインデックス
     */
    public TreeViewerSorter() {
    	
    }

    /**
     * 比較処理
     * 
     * @param viewer
     * @param e1
     * @param e2
     * @return 比較結果。superクラスの結果をソートオーダーにより反転する
     */
    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof TreeItem && e2 instanceof TreeItem) {
            Integer object1 = new Integer(((TreeItem)e1).getInfo().getOrderNo());
            Integer object2 = new Integer(((TreeItem)e2).getInfo().getOrderNo());

            int rtn = object1.compareTo(object2);

            return rtn;
        }
        return 0;
    }
}