/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.jobmanagement.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ジョブ[ノード詳細]ビューの一覧情報を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、ノード詳細一覧情報を取得する
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetNodeDetail {
	
	/**
	 * マネージャにSessionBean経由でアクセスし、ノード詳細一覧情報を取得する
	 * 
	 * @param sessionId セッションID
	 * @param jobId ジョブID
	 * @return ノード詳細一覧情報（Objectの2次元配列）
	 * @throws AccessException 
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobController
	 * @see com.clustercontrol.jobmanagement.util.EjbConnectionManager
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerBean#getNodeDetailList(java.lang.String, java.lang.String, java.util.Locale)
	 */
	public ArrayList getNodeDetail(String sessionId, String jobId) {
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();
		
		ArrayList list = null;
		
		try {
			list = job.getNodeDetailList(sessionId, jobId, Locale.getDefault());
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
		} catch (FinderException e) {
		} catch (NamingException e) {
		} catch (CreateException e) {
		}
		
		return list;
	}
}
