/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.jobmanagement.view.RunScheduleDetailListView;
import com.clustercontrol.jobmanagement.view.RunScheduleListView;

/**
 * ジョブ[実行予定]及びジョブ[実行予定詳細]ビューの「予定の表示」のクライアント側アクションクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ScheduleShowAction implements IViewActionDelegate {
	/** アクションID */
	public static final String ID = "com.clustercontrol.jobmanagement.view.action.ScheduleShowAction";
	/** ビュー */
    private IViewPart viewPart;

    /**
     * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
     * 
     * @param view ビューのインスタンス
     * 
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart view) {
        viewPart = view;
    }

    /**
     * ジョブ[実行予定]またはジョブ[実行予定詳細]ビューの「予定の表示」が押された場合に、<BR>
     * ジョブ[実行予定]またはジョブ[実行予定詳細]ビューの右側のコンポジットの表示・非表示を切り替えます。
     * 
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     * @see com.clustercontrol.jobmanagement.view.RunScheduleListView
     * @see com.clustercontrol.jobmanagement.view.RunScheduleDetailListView
     */
    public void run(IAction action) {
        if (viewPart instanceof RunScheduleListView) { // ボタンが押された場合
        	RunScheduleListView view = (RunScheduleListView) viewPart
                    .getAdapter(RunScheduleListView.class);

            if (action.isChecked()) {
                view.showSchedule();
            } else {
                view.hideSchedule();
            }

            view.setFocus();
            
        } else if (viewPart instanceof RunScheduleDetailListView) { // ボタンが押された場合
        	RunScheduleDetailListView view = (RunScheduleDetailListView) viewPart
                    .getAdapter(RunScheduleDetailListView.class);

            if (action.isChecked()) {
                view.showSchedule();
            } else {
                view.hideSchedule();
            }

            view.setFocus();
        }
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}