/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.factory;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.StatusConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;

/**
 * ジョブ操作の保留に関する処理を行うクラスです。
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class OperateWaitOfJob extends OperationJob {
	/** ログ出力のインスタンス */
	protected static Log m_log = LogFactory.getLog( OperateWaitOfJob.class );
	
	/**
	 * コンストラクタ
	 */
	public OperateWaitOfJob(){
		super();
	}
	
	/**
	 * ジョブを停止[保留]します。
	 * 
	 * @param sessionId セッションID
	 * @param jobId ジョブID
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void waitJob(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("waitJob() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//セッションIDとジョブIDから、セッションジョブを取得
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		if(sessionJob != null){
			//実行状態が待機の場合、実行状態を保留中にする
			if(sessionJob.getStatus().intValue() == StatusConstant.TYPE_WAIT){
				sessionJob.setStatus(Integer.valueOf(StatusConstant.TYPE_RESERVING));
			}
		}
	}
	
	/**
	 * ジョブを開始[保留解除]します。
	 * 
	 * @param sessionId セッションID
	 * @param jobId ジョブID
	 * @throws FinderException
	 * @throws NamingException
	 */
	public void releaseWaitJob(String sessionId, String jobId) throws FinderException, NamingException {
		m_log.debug("releaseWaitJob() : sessionId=" + sessionId + ", jobId=" + jobId);
		
		//セッションIDとジョブIDから、セッションジョブを取得
		JobSessionJobLocal sessionJob = 
			JobSessionJobUtil.getLocalHome().findByPrimaryKey(
					new JobSessionJobPK(sessionId, jobId));
		
		if(sessionJob != null){
			//実行状態が保留中の場合、実行状態を待機にする
			if(sessionJob.getStatus().intValue() == StatusConstant.TYPE_RESERVING){
				sessionJob.setStatus(Integer.valueOf(StatusConstant.TYPE_WAIT));
			}
		}
	}
}
