/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.factory;

import java.rmi.RemoteException;
import java.sql.SQLException;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.maintenance.bean.MaintenanceTypeMstConstant;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoLocal;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoUtil;
import com.clustercontrol.maintenance.ejb.session.MaintenanceController;
import com.clustercontrol.maintenance.ejb.session.MaintenanceControllerUtil;

/**
 * 
 * メンテナンス機能が提供する操作を実行するクラスです。
 * 
 * @version 3.0.0
 * @since 2.2.0
 *
 */
public class OperationMaintenance {
	
	public void runMaintenance(String maintenanceId) {

		int result = -1;
		Integer type = PriorityConstant.TYPE_CRITICAL;
		String msg = null;
		
		try {
			MaintenanceInfoLocal info = MaintenanceInfoUtil.getLocalHome().findByPrimaryKey(maintenanceId);
			MaintenanceController controller = MaintenanceControllerUtil.getHome().create();
			
			String keep_id = info.getKeep_id();
			String type_id = info.getType_id();
			
			if (MaintenanceTypeMstConstant.DELETE_EVENT_LOG.equals(type_id)) {
				
				result = controller.deleteEventLog(keep_id);
				
			} else if (MaintenanceTypeMstConstant.DELETE_JOB_HISTORY.equals(type_id)) {
				
				result = controller.deleteJobHistory(keep_id);
				
			} else if (MaintenanceTypeMstConstant.DELETE_CRUN_HISTORY.equals(type_id)) {
				
				result = controller.deleteCollectiveRunHistory(keep_id);
			}
			
			type = PriorityConstant.TYPE_INFO;
			
		} catch (FinderException e) {
			e.printStackTrace();
		} catch (NamingException e) {
			e.printStackTrace();
		} catch (RemoteException e) {
			e.printStackTrace();
		} catch (CreateException e) {
			e.printStackTrace();
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			try {
				new Notice().notify(maintenanceId, type.intValue(), result);
			} catch (FinderException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			} catch (NamingException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}

		}
	}

}
