/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.view;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.monitor.MonitorPlugin;
import com.clustercontrol.monitor.composite.ScopeListComposite;
import com.clustercontrol.monitor.preference.MonitorPreferencePage;
import com.clustercontrol.view.ScopeListBaseView;

/**
 * 監視[スコープ]ビュークラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopeView extends ScopeListBaseView {
    public static final String ID = "com.clustercontrol.monitor.view.ScopeView";

    /** スコープ情報一覧コンポジット */
    private ScopeListComposite tableComposite = null;


    /**
     * スコープ情報一覧テーブルを作成・追加します。
     * <p>
	 * <ol>
	 * <li>スコープ情報一覧テーブルを取得します。</li>
	 * <li>ビューを更新します。</li>
	 * <li>プレファレンスページの設定より、監視[スコープ]ビューの自動更新周期を取得し、このビューにセットします。</li>
	 * <li>プレファレンスページの設定より、監視[スコープ]ビューの自動更新フラグを取得し、このビューにセットします。</li>
	 * <li>スコープ情報一覧テーブルを返します。</li>
	 * </ol>
     * 
     * @param parent 親のコンポジット
     * @return スコープ情報一覧テーブルコンポジット
     * 
     * @see com.clustercontrol.monitor.composite.ScopeListComposite#ScopeListComposite(Composite, int)
     * @see #update()
     */
    protected Composite createListContents(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        this.tableComposite = new ScopeListComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.tableComposite.setLayoutData(gridData);

        this.update();

        // 設定情報反映
        IPreferenceStore store = MonitorPlugin.getDefault()
                .getPreferenceStore();

        this.setInterval(store
                .getInt(MonitorPreferencePage.P_SCOPE_UPDATE_CYCLE));

        if (store.getBoolean(MonitorPreferencePage.P_SCOPE_UPDATE_FLG)) {
            this.startAutoReload();
        }

        return this.tableComposite;
    }

    /**
     * スコープツリーでアイテムを選択した際に呼ばれ、ビューを更新します。
     * 
     * @param item スコープツリーアイテム
     * 
     * @see com.clustercontrol.monitor.composite.ScopeListComposite#update(String)
     */
    protected void doSelectTreeItem(FacilityTreeItem item) {
        this.tableComposite.update(item.getData().getFacilityId());
    }

    /**
     * ビューを更新します。<BR>
     * <p>
	 * <ol>
	 * <li>スコープツリーで選択されているアイテムを取得します。</li>
	 * <li>アイテムより、ファシリティIDを取得します。</li>
	 * <li>ファシリティIDをキーに、イベント情報を更新します。</li>
	 * </ol>
	 * 
	 * @see com.clustercontrol.monitor.composite.ScopeListComposite#update(String)
     */
    public void update() {
        FacilityTreeItem item = this.getScopeTreeComposite().getSelectItem();
        String facilityId = null;
        if (item != null) {
            facilityId = item.getData().getFacilityId();
        }

        this.tableComposite.update(facilityId);
    }
}