/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.ejb.entity;

import java.util.Collection;

import javax.ejb.EntityBean;

/**
 * 文字列監視判定情報のCMP Entity Bean<BR>
 * 
 * @ejb.bean name="MonitorStringValueInfo"
 *           jndi-name="MonitorStringValueInfo"
 *           schema="MonitorStringValueInfo" 
 *           type="CMP"
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="monitorTypeId","monitorId","order_no"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @jboss.container-configuration
 *    name="Instance Per Transaction CMP 2.x EntityBean"
 *
 * @jboss.optimistic-locking
 *    modified-strategy="true"
 * 
 * @ejb.permission
 *     unchecked="true"
 *           
 * @ejb.persistence 
 *   table-name="cc_monitor_string_value_info" 
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorStringValueInfo as a"  
 *    signature="java.util.Collection findAll()"  
 *
 * @ejb.pk class="com.clustercontrol.monitor.run.ejb.entity.MonitorStringValueInfoPK"
 *           
 */
public abstract class MonitorStringValueInfoBean implements EntityBean {
	
	/**
	 * 文字列監視判定情報を生成します。
	 * 
	 * @ejb.create-method 
	 * 
	 * @param monitorTypeId 監視対象ID
	 * @param monitorId 監視項目ID
	 * @param orderNo 順序
	 * @param description 説明
	 * @param processType 処理タイプ
	 * @param pattern パターンマッチ表現
	 * @param priority 重要度
	 * @param messageId メッセージID
	 * @param message メッセージ
	 * @param notifyGroupId 通知グループID
	 * @param notifyId 通知IDのコレクション
	 * @param validFlg 有効/無効
	 * @return プライマリキー
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.ProcessConstant
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.YesNoConstant
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public MonitorStringValueInfoPK ejbCreate(
			String monitorTypeId, 
			String monitorId, 
			Integer orderNo,
			String description,
			Integer processType,
			String pattern,
			Integer priority, 
			String messageId, 
			String message,
			String notifyGroupId,
			Integer validFlg
			) throws javax.ejb.CreateException {

		this.setMonitorTypeId(monitorTypeId);
		this.setMonitorId(monitorId);
		this.setOrderNo(orderNo);
		this.setDescription(description);
		this.setProcessType(processType);
		this.setPattern(pattern);
		this.setPriority(priority);
		this.setMessageId(messageId);
		this.setMessage(message);
		this.setNotifyGroupId(notifyGroupId);
		this.setValidFlg(validFlg);
		
		return null;
	}
	
	/**
	 * 通知グループIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_group_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知グループID
	 */
	public abstract String getNotifyGroupId();

	/**
	 * 通知グループIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param failureMessage 通知グループID
	 */
	public abstract void setNotifyGroupId(String notifyGroupId);

	
	/**
	 * 説明を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="description"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 説明
	 */
	public abstract String getDescription();

	/**
	 * 説明を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param description 説明
	 */
	public abstract void setDescription(String description);
	
	/**
	 * メッセージを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="message"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(256)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return メッセージ
	 */
	public abstract String getMessage();

	/**
	 * メッセージを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param message メッセージ
	 */
	public abstract void setMessage(String message);

	/**
	 * メッセージIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="message_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return メッセージID
	 */
	public abstract String getMessageId();

	/**
	 * メッセージIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param messageId メッセージID
	 */
	public abstract void setMessageId(String messageId);

	/**
	 * 監視項目IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 監視項目ID
	 */
	public abstract String getMonitorId();

	/**
	 * 監視項目IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorId 監視項目ID
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * 監視対象IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 監視対象ID
	 */
	public abstract String getMonitorTypeId();

	/**
	 * 監視対象IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId 監視対象ID
	 */
	public abstract void setMonitorTypeId(String monitorTypeId);
	
	/**
	 * 順序を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="order_no"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 順序
	 */
	public abstract Integer getOrderNo();

	/**
	 * 順序を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param orderNo 順序
	 */
	public abstract void setOrderNo(Integer orderNo);
	
	/**
	 * パターンマッチ表現を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="pattern"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return パターンマッチ表現
	 */
	public abstract String getPattern();

	/**
	 * パターンマッチ表現を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param pattern パターンマッチ表現
	 */
	public abstract void setPattern(String pattern);
	
	/**
	 * 重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract Integer getPriority();

	/**
	 * 重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param priority 重要度
	 * 
	 * @see com.clustercontrol.bean.PriorityConstant
	 */
	public abstract void setPriority(Integer priority);
	
	/**
	 * 処理タイプを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="process_type"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 処理タイプ
	 * 
	 * @see com.clustercontrol.bean.ProcessConstant
	 */
	public abstract Integer getProcessType();

	/**
	 * 処理タイプを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param processType 処理タイプ
	 * 
	 * @see com.clustercontrol.bean.ProcessConstant
	 */
	public abstract void setProcessType(Integer processType);
		
	/**
	 * 有効/無効を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="valid_flg"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *  
	 * @ejb.interface-method
	 * 
	 * @return 有効/無効
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract Integer getValidFlg();

	/**
	 * 有効/無効を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param validFlg 有効/無効
	 * 
	 * @see com.clustercontrol.bean.ValidConstant
	 */
	public abstract void setValidFlg(Integer validFlg);
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	
    /**
     * 監視情報を返します。
     * 
     * @ejb.interface-method view-type="local"
     * 
     * @ejb.relation 
     * name="MonitorInfo-MonitorStringValueInfo"
     * role-name="MonitorStringValueInfo-MonitorInfo(multi)"
     * cascade-delete="yes"
     * 
     * @jboss.relation
	 * related-pk-field="monitorTypeId"
	 * fk-column="monitor_type_id"
	 * 
	 * @jboss.relation
	 * related-pk-field="monitorId"
	 * fk-column="monitor_id"
	 * 
	 * @return 監視情報
	 * 
	 * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
     */
    public abstract MonitorInfoLocal getMonitorInfo();
    
    /**
     * 監視情報を設定します。
     * 
     * @ejb.interface-method view-type="local"
     * 
     * @param monitorInfo 監視情報
     * 
     * @see com.clustercontrol.monitor.run.ejb.entity.MonitorInfoBean
     */
    public abstract void setMonitorInfo(MonitorInfoLocal monitorInfo);
    
 
}
