/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.ejb.entity;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.EJBException;
import javax.ejb.EntityBean;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;



/**
 * 監視抑制情報のCMP Entity Bean
 * 
 * @ejb.bean name="NotifyActionInhibitionInfo"
 *           jndi-name="NotifyActionInhibitionInfo"
 *           type="CMP"
 *           schema="NotifyActionInhibitionInfo" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="notifyGroupId","notifyId","facilityId"
 * 
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.permission
 *     unchecked="true"
 *        
 * @ejb.persistence 
 *   table-name="cc_action_inhibition_info" 
 *    
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM NotifyActionInhibitionInfo as a"  
 *    signature="java.util.Collection findAll()" 
 *    
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM NotifyActionInhibitionInfo as a WHERE a.notifyGroupId = ?1" 
 *    signature="java.util.Collection findByNotifyGroupId(java.lang.String notifyGroupId)"
 * 
 * @ejb.finder 
 *    query="SELECT OBJECT(a) FROM NotifyActionInhibitionInfo as a WHERE a.notifyId = ?1" 
 *    signature="java.util.Collection findByNotifyId(java.lang.String notifyId)"
 *
 * @ejb.pk class="com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoPK" 
 *           
 */
public abstract class NotifyActionInhibitionInfoBean implements EntityBean {
	
	/**
	 * 監視情報を生成します。
	 * 
	 * @ejb.create-method 
	 * 
	 * @param notifyGroupId 通知グループID
	 * @param notifyId 通知ID
	 * @param faciligyId ファシリティID
	 * @param priority 重要度
	 * @param lastNotifyDate 最終通知日時
	 * @param lastUpdateDate 最終更新日時
	 * @param dupulicationCount 重複カウンタ
	 * @param totalCount カウント合計
	 * @throws javax.ejb.CreateException
	 * 
	 * @see com.clustercontrol.bean.RunIntervalConstant
	 * @see com.clustercontrol.monitor.run.bean.MonitorTypeConstant
	 * @see com.clustercontrol.bean.MonitorBlockConstant
	 * @see com.clustercontrol.bean.PriorityConstant
	 * @see com.clustercontrol.bean.YesNoConstant
	 */
	public NotifyActionInhibitionInfoPK ejbCreate(
			String notifyGroupId, 
			String notifyId, 
			String facilityId,
			Integer priority,
			Timestamp lastNotifyDate,
			Timestamp lastUpdateDate,
			Long dupulicationCount,
			Long totalCount
			) throws javax.ejb.CreateException {

		this.setNotifyGroupId(notifyGroupId);
		this.setNotifyId(notifyId);
		this.setFacilityId(facilityId);
		this.setPriority(priority);
		this.setLastNotifyDate(lastNotifyDate);
		this.setLastUpdateDate(lastUpdateDate);
		this.setDupuricationCount(dupulicationCount);
		this.setTotalCount(totalCount);	
		return null;
	}

	/**
	 * 通知グループIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_group_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(1024)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知グループID
	 */
	public abstract String getNotifyGroupId();

	/**
	 * 通知グループIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param monitorId 通知グループID
	 */
	public abstract void setNotifyGroupId(String notifyGroupId);
	
	/**
	 * 通知IDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="notify_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return 通知ID
	 */
	public abstract String getNotifyId();

	/**
	 * 通知IDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param notifyId 通知ID
	 */
	public abstract void setNotifyId(String notifyId);

	/**
	 * ファシリティIDを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="facility_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 *
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return ファシリティID
	 */
	public abstract String getFacilityId();

	/**
	 * ファシリティIDを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param facilityId ファシリティID
	 */
	public abstract void setFacilityId(String facilityId);
    
	/**
	 * 重要度を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="priority"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 重要度
	 * 
	 */
	public abstract Integer getPriority();

	/**
	 * 重要度を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param priority 重要度
	 * 
	 */
	public abstract void setPriority(Integer priority);
	
	/**
	 * 重複カウンタを返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="duplication_count"
	 *     jdbc-type="BIGINT"
	 *     sql-type="bigint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 重複カウンタ
	 * 
	 */
	public abstract Long getDupuricationCount();

	/**
	 * 重複カウンタを設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param dupuricationCount 重複カウンタ
	 * 
	 */
	public abstract void setDupuricationCount(Long dupuricationCount);
	
	/**
	 * 最終通知日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="last_notify_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 最終通知日時
	 * 
	 */
	public abstract Timestamp getLastNotifyDate();

	/**
	 * 最終通知日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param lastNotifyDate 最終通知日時
	 * 
	 */
	public abstract void setLastNotifyDate(Timestamp lastNotifyDate);
	
	/**
	 * 最終更新日時を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="last_update_date"
	 *     jdbc-type="TIMESTAMP"
	 *     sql-type="TIMESTAMP"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return 最終更新日時
	 * 
	 */
	public abstract Timestamp getLastUpdateDate();

	/**
	 * 最終更新日時を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param lastUpdateDate 最終更新日時
	 * 
	 */
	public abstract void setLastUpdateDate(Timestamp lastNotifyDate);
	
	/**
	 * カウント合計を返します。
	 * 
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="total_count"
	 *     jdbc-type="BIGINT"
	 *     sql-type="bigint"
	 *     read-only="false"
	 *
	 * @ejb.interface-method
	 * 
	 * @return カウント合計
	 * 
	 */
	public abstract Long getTotalCount();

	/**
	 * カウント合計を設定します。
	 * 
	 * @ejb.interface-method
	 * 
	 * @param totalCount カウント合計
	 * 
	 */
	public abstract void setTotalCount(Long totalCount);
	
}
