/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.factory;

import java.util.Collection;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.bean.NotifyRelationInfo;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoUtil;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoLocal;
import com.clustercontrol.notify.ejb.entity.NotifyRelationInfoUtil;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * 抑制情報を変更するクラスです。
 *
 * @version 3.0.0
 * @since 3.0.0
 */
public class ModifyNotifyInhibition {
	
	/** ログ出力のインスタンス。 */
	protected static Log m_log = LogFactory.getLog( ModifyNotifyInhibition.class );
	
	/**
	 * 抑制情報を変更します。
	 * <p>
	 * <ol>
	 *  <li>通知IDより、通知情報を取得します。</li>
	 *  <li>通知情報を変更します。</li>
	 *  <li>通知情報に設定されている内容を確認し、差分のみ削除します。</li>
	 * </ol>
	 * 
	 * @param info 変更対象の通知情報
	 * @return 変更に成功した場合、<code> true </code>
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @throws JMSException
	 * 
	 * @see com.clustercontrol.notify.ejb.entity.NotifyRelationInfoLocal
	 * @see com.clustercontrol.notify.ejb.entity.NotifyActionInhibitionInfoLocal
	 */
	@SuppressWarnings("unchecked")
	public boolean modify(String notifyGroupId) throws FinderException, RemoveException, NamingException {
		//アクセスロック
		AccessLock.lock(AccessLock.NOTIFY);		
		
		try 
		{
			NotifyRelationInfoLocal relation = null;
			NotifyActionInhibitionInfoLocal inhibit = null;
			String newNotifyId = null;
			String oldNotifyId = null;
		
			// 既に更新されている関連テーブルから、通知グループIDで取得する
			Collection<NotifyRelationInfoLocal> ctRelation = NotifyRelationInfoUtil.getLocalHome().findByNotifyGroupId(notifyGroupId);
			// 削除対象となる抑制テーブルを、通知グループIDで取得する
			Collection<NotifyActionInhibitionInfoLocal> ctInhibit = NotifyActionInhibitionInfoUtil.getLocalHome().findByNotifyGroupId(notifyGroupId);

			// 変更前の抑制テーブルと内容と、変更されている関連テーブルの内容を比較し、
			// マッチしなければ、抑制テーブルの内容を削除する。
			// （新しい抑制テーブルは、抑制時に自動的に作成されるため、ここでは作成しない）
			Iterator<NotifyActionInhibitionInfoLocal> itInhibit = ctInhibit.iterator();
			while(itInhibit.hasNext()) {
				inhibit = itInhibit.next();
				oldNotifyId = inhibit.getNotifyId();
				boolean isDelete = true;
				
				Iterator<NotifyRelationInfoLocal> itRelation = ctRelation.iterator();
				while(itRelation.hasNext()) {
					relation = itRelation.next();
					newNotifyId = relation.getNotifyId();
					
					if(newNotifyId.equals(oldNotifyId)){
						isDelete = false;
						break;
					}
				}
				
				if(isDelete) {
					inhibit.remove();
				}
			}
			
		} catch (FinderException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
		//	String[] args = { info.getNotifyId() };
//			apllog.put("SYS", "002", args);
			m_log.debug("modify():" + e.getMessage());
			throw e;
		} catch (RemoveException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
//			String[] args = { info.getNotifyId() };
//			apllog.put("SYS", "002", args);
			m_log.debug("modify():" + e.getMessage());
			throw e;
		} catch (NamingException e) {
			AplLogger apllog = new AplLogger("NOTIFY", "notify");
//			String[] args = { info.getNotifyId() };
//			apllog.put("SYS", "002", args);
			m_log.debug("modify():" + e.getMessage());
			throw e;
		}
		return true;
	}
	
}
