/*
Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/
package com.clustercontrol.performance.bean;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.performance.ejb.bmp.CollectorLocalHome;

/**
 * Quartz関連定数クラス
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class QuartzConstant {
	private static Log m_log = LogFactory.getLog( QuartzConstant.class );
	
	public static final String GROUP_COLLECT  = "PERF_COLLECT";
	public static final String GROUP_MONITOR  = "PERF_MONITOR";
	public static final String JNDI_NAME = CollectorLocalHome.JNDI_NAME;
//	public static final String QUARTZ_NAME = "QuartzRAM";
	//public static final String JNDI_NAME_PERF = CollectorRunManagementHome.JNDI_NAME;
	public static final String JNDI_NAME_PERF_MNG ="CollectorRunController";
	public static final String METHOD_NAME_PERF_MNG = "managePresavePeriod";
	
	public static String m_quartzName = "QuartzRAM";
	
	public static int m_delayTimeUnder1min;
	public static int m_delayTimeOver1min;
	
	/**
	 * 性能管理機能で利用するQuartzスケジューラへ参照可能なJNDI名を返す。
	 * 
	 * @return JNDI名
	 */
	public static String getQuartzName() {
		return m_quartzName;
	}
		
	/**
	 * 性能管理機能で利用するQuartzスケジューラへ参照可能なJNDI名を設定する。
	 */
	public static void setQuartzName(String quartzName) {
		m_quartzName = quartzName;
	}

    /**
	 * 計算処理実行開始を設定するための、SNMPポーリングからのディレイタイムを返します。
	 * 対象は、収集間隔1分未満のもの
	 * @return ディレイタイム
     */
	public static int getDelayTimeUnder1min() {
		return m_delayTimeUnder1min;
	}

    /**
	 * 計算処理実行開始を設定するための、SNMPポーリングからのディレイタイムを設定します。
	 * 対象は、収集間隔1分未満のもの
     */
	public static void setDelayTimeUnder1min(int delayTimeUnder1min) {
		m_delayTimeUnder1min = delayTimeUnder1min;
	}

	/**
	 * 計算処理実行開始を設定するための、SNMPポーリングからのディレイタイムを返します。
	 * 対象は、収集間隔1分以上のもの
	 * @return ディレイタイム
	 */
	public static int getDelayTimeOver1min() {
		return m_delayTimeOver1min;
	}

	/**
	 * 計算処理実行開始を設定するための、SNMPポーリングからのディレイタイムを設定します。
	 * 対象は、収集間隔1分以上のもの
	 */
	public static void setDelayTimeOver1min(int delayTimeOver1min) {
		m_delayTimeOver1min = delayTimeOver1min;
	}
}
