/*
                                                                                                                                                                 
Copyright (C) 2008 NTT DATA Corporation
                                                                                                                                                                 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
                                                                                                                                                                 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
                                                                                                                                                                 
*/

package com.clustercontrol.performance.operator;

import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.sharedtable.DataTable;

public abstract class Operator {
	// 生成直後に初期化する項目
	private String platformId;
	private String itemCode;
	private List<String> variables = new ArrayList<String>();

	// 値算出直前に設定する変数
	private DataTable currentTable;
	private DataTable previousTable;
	private long deviceIndex;
	
	
	public abstract double calc() throws CollectedDataNotFoundException, InvalidValueException;
	
	protected void setDataTable(DataTable currentTable, DataTable previousTable){
		this.currentTable = currentTable;
		this.previousTable = previousTable;
	}
	
	/**
	 * 直近収集時の値を取得します
	 * @param variable 変数名
	 * @return 収集値
	 */
	protected abstract double getCurrentMibValue(String variable)
	throws CollectedDataNotFoundException, InvalidValueException;
	
	/**
	 * 前回収集時の値を取得します
	 * @param variable 変数名
	 * @return 収集値
	 */
	protected abstract double getPreviousMibValue(String variable)
	throws CollectedDataNotFoundException, InvalidValueException;
	
	/**
	 * 全変数の直近収集値の合計値を取得します
	 * @return 合計値
	 */
	protected abstract double getCurrentMibValueTotal()
	throws CollectedDataNotFoundException, InvalidValueException;

	/**
	 * 全変数の前回収集値の合計値を取得します
	 * @return 合計値
	 */
	protected abstract double getPreviousMibValueTotal()
	throws CollectedDataNotFoundException, InvalidValueException;

	/**
	 * 前回収集時からの差分を取得します。
	 * @param variable 変数名
	 * @return 差分値
	 */
	protected abstract double getDifferenceValue(String variable)
	throws CollectedDataNotFoundException, InvalidValueException;

	/**
	 * 全変数の前回収集時からの差分の合計を取得します。
	 * @param variable 変数名
	 * @return 差分値
	 */
	protected abstract double getDifferenceValueTotal()
	throws CollectedDataNotFoundException, InvalidValueException;
	
	public DataTable getCurrentTable() {
		return currentTable;
	}

	public void setCurrentTable(DataTable currentTable) {
		this.currentTable = currentTable;
	}

	public DataTable getPreviousTable() {
		return previousTable;
	}

	public void setPreviousTable(DataTable previousTable) {
		this.previousTable = previousTable;
	}

	public String getPlatformId() {
		return platformId;
	}

	public void setPlatformId(String platformId) {
		this.platformId = platformId;
	}

	public String getItemCode() {
		return itemCode;
	}

	public void setItemCode(String itemCode) {
		this.itemCode = itemCode;
	}

	public long getDeviceIndex() {
		return deviceIndex;
	}

	public void setDeviceIndex(long deviceIndex) {
		this.deviceIndex = deviceIndex;
	}

	public List<String> getVariables() {
		return variables;
	}

	public void setVariables(List<String> variables) {
		this.variables = variables;
	}
	
	public class InvalidValueException extends Exception {
		private static final long serialVersionUID = -1102457433444726271L;
	}

	public class CollectedDataNotFoundException extends Exception {
		private static final long serialVersionUID = 6306555743811316089L;
	}
}
