/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.ping.ejb.entity;

import javax.ejb.EntityBean;

/**
 * PING監視を管理するEntity Bean
 * 
 * @ejb.bean name="MonitorPingInfo"
 *           jndi-name="MonitorPingInfo"
 *           type="CMP"
 *           schema="MonitorPingInfo" 
 *           cmp-version="2.x"
 *           data-source="java:/HinemosDS"
 *           primkey-field="monitorTypeId","monitorId"
 *           
 *  @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 *  
 *  @jboss.container-configuration
 *     name="Instance Per Transaction CMP 2.x EntityBean"
 *
 *  @jboss.optimistic-locking
 *     modified-strategy="true"
 *  
 *  @ejb.permission
 *     unchecked="true"
 *     
 *  @ejb.persistence 
 *   table-name="cc_monitor_ping_info"  
 *           
 *  @ejb.finder 
 *    query="SELECT OBJECT(a) FROM MonitorPingInfo as a"  
 *    signature="java.util.Collection findAll()"  
 *
 *  @ejb.pk class="com.clustercontrol.ping.ejb.entity.MonitorPingInfoPK"
 *   
 */
public abstract class MonitorPingInfoBean implements EntityBean {
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public MonitorPingInfoPK ejbCreate(
			String monitorTypeId,
			String monitorId, 
			Integer runCount, 
			Integer runInterval,
			Integer timeout
			) throws javax.ejb.CreateException {
		
		this.setMonitorTypeId(monitorTypeId);
		this.setMonitorId(monitorId);
		this.setRunCount(runCount);
		this.setRunInterval(runInterval);
		this.setTimeout(timeout);
		return null;
	}
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorId.
	 */
	public abstract String getMonitorId();

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorId The monitorId to set.
	 */
	public abstract void setMonitorId(String monitorId);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="monitor_type_id"
	 *     jdbc-type="VARCHAR"
	 *     sql-type="VARCHAR(64)"
	 *     read-only="false"
	 * @ejb.pk-field 
	 *
	 * @ejb.interface-method
	 * 
	 * @return Returns the monitorTypeId.
	 */
	public abstract String getMonitorTypeId();
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="run_count"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the runCount.
	 */
	public abstract Integer getRunCount();

	/**
	 * @ejb.interface-method
	 * 
	 * @param runCount The runCount to set.
	 */
	public abstract void setRunCount(Integer runCount);

	/**
	 * @ejb.interface-method
	 * 
	 * @param monitorTypeId The monitorTypeId to set.
	 */
	public abstract void setMonitorTypeId(String monitorTypeId);

	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="run_interval"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the runInterval.
	 */
	public abstract Integer getRunInterval();

	/**
	 * @ejb.interface-method
	 * 
	 * @param runInterval The runInterval to set.
	 */
	public abstract void setRunInterval(Integer runInterval);
	
	/**
	 * @ejb.persistent-field 
	 * @ejb.persistence
	 *    column-name="timeout"
	 *     jdbc-type="SMALLINT"
	 *     sql-type="smallint"
	 *     read-only="false"
	 * 
	 * @ejb.interface-method
	 * 
	 * @return Returns the timeout.
	 */
	public abstract Integer getTimeout();

	/**
	 * @ejb.interface-method
	 * 
	 * @param timeout The timeout to set.
	 */
	public abstract void setTimeout(Integer timeout);

}
