/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.composite.action;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.repository.view.ScopeListView;

/**
 * リポジトリ[スコープ]ビューのツリービューア用のSelectionChangedListenerクラス<BR>
 * 
 * @version 2.2.0
 * @since 2.2.0
 */
public class FacilityTreeSelectionChangedListener implements ISelectionChangedListener {
	
    /**
     * コンストラクタ
     */
    public FacilityTreeSelectionChangedListener() {
    	
    }
    
    /**
     * 選択変更時に呼び出されます。<BR>
     * リポジトリ[スコープ]ビューのツリービューアを選択した際に、<BR>
     * 選択したアイテムの内容でリポジトリ[スコープ]ビューのアクションの有効・無効を設定します。
     * <P>
     * <ol>
	 * <li>選択変更イベントからファシリティツリーアイテムを取得します。</li>
	 * <li>リポジトリ[スコープ]ビューのアクションの有効・無効を設定します。</li>
	 * </ol>
	 * 
     * @param event 選択変更イベント
     * 
     * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
     */
    public void selectionChanged(SelectionChangedEvent event) {
    	FacilityTreeItem selectItem = null;
    	
    	if (((StructuredSelection) event.getSelection()).getFirstElement() != null) {
    		//選択アイテムを取得
    		selectItem = (FacilityTreeItem) ((StructuredSelection) event.getSelection()).getFirstElement();
    	}
    	
    	// リポジトリ[登録]ビューのインスタンスを取得
    	IWorkbenchPage page = PlatformUI.getWorkbench()
    			.getActiveWorkbenchWindow().getActivePage();
    	IViewPart viewPart = page.findView(ScopeListView.ID);
    	
    	if (viewPart != null && selectItem instanceof FacilityTreeItem) {
    		ScopeListView view = (ScopeListView) viewPart.getAdapter(ScopeListView.class);

    		// ビューのアクションの有効/無効を設定
            view.setEnabledAction(selectItem.getData().isBuiltInFlg(),selectItem.getData().getType(), event.getSelection());
    	}
    	
    }
}