/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.FacilityConstant;
import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.repository.action.DeleteScopeProperty;
import com.clustercontrol.repository.composite.ScopeListComposite;
import com.clustercontrol.repository.view.ScopeListView;
import com.clustercontrol.util.Messages;

/**
 * スコープの削除を行うクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class ScopeDeleteAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.repository.view.action.ScopeDeleteAction";

    //	 ----- instance フィールド ----- //

    private IViewPart viewPart; // ビュー

    // ----- instance メソッド ----- //

    /**
     * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
     */
    public void init(IViewPart viewPart) {
        this.viewPart = viewPart;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action) {
        // スコープ一覧より、選択されているアイテムを取得
        // スコープツリーより、選択されているスコープを取得
        ScopeListView view = (ScopeListView) this.viewPart
                .getAdapter(ScopeListView.class);

        FacilityTreeComposite tree = view.getScopeTreeComposite();
        ScopeListComposite list = (ScopeListComposite)view.getListComposite();
        
        FacilityTreeItem item = null;
        if(tree.getTree().isFocusControl()){
			item = tree.getSelectItem();
        }
        else if(list.getTableViewer().getTable().isFocusControl()){
        	item = list.getSelectItem();
        }
        else{
        	return;
        }

        // 未選択の場合は、処理終了
        if (item == null) {
            return;
        }
        // コンポジット・ノードを選択している場合は、処理終了
        FacilityInfo info = item.getData();
        if (item == null || info.getType() == FacilityConstant.TYPE_COMPOSITE
                || info.getType() == FacilityConstant.TYPE_NODE) {
            return;
        }

        String facilityId = info.getFacilityId();
        String facilityName = info.getFacilityName();

        // 確認ダイアログにて変更が選択された場合、削除処理を行う。
        String[] args = { facilityName, facilityId };
        if (MessageDialog.openConfirm(
    			null, 
    			Messages.getString("confirmed"), 
    			Messages.getString("message.repository.3", args))) {

            if (new DeleteScopeProperty().delete(facilityId)) {
                // 成功報告ダイアログを生成
            	MessageDialog.openInformation(
            			null, 
            			Messages.getString("successful"), 
            			Messages.getString("message.repository.16"));
            } else {
                // 失敗報告ダイアログを生成
            	MessageDialog.openError(
            			null, 
            			Messages.getString("failed"), 
            			Messages.getString("message.repository.17"));
            }

            // ビューを更新
            tree.update();
            view.update();
        }
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void selectionChanged(IAction action, ISelection selection) {
    }
}