/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.repository.util;

import java.util.HashMap;
import java.util.Set;

/**
 * データテーブルクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class DataTable implements Cloneable {
	HashMap<String, ValueObject> m_hm; 
	long m_lastReference = 0;	
	long m_lastReferenceInterval;  

	public DataTable(){
		m_hm = new HashMap<String, ValueObject>();
		m_lastReference = System.currentTimeMillis();
	}

	private DataTable(HashMap<String, ValueObject> hp, long lastReference){
		m_hm = hp;
	}

	/**
	 * 値を入れます。
	 * @param key
	 * @param date
	 * @param value
	 */
	synchronized public void putValue(String key, long date, Object value) {
		m_hm.put(key, new ValueObject(key, date, value));
	}

	/**
	 * 
	 * @param table
	 */
	synchronized public void putValueAll(DataTable table) {
		m_hm.putAll(table.m_hm);
	}


	/**
	 * 
	 * @param table
	 */
	synchronized public void setValueAll(DataTable table) {
		m_hm.clear();
		m_hm.putAll(table.m_hm);
	}
	

	/**
	 * 
	 * @param key
	 * @return
	 */
	synchronized public ValueObject getValue(String key){
		ValueObject vo = (ValueObject)m_hm.get(key);
		long now = System.currentTimeMillis();
		m_lastReferenceInterval = now - m_lastReference;
		
		m_lastReference = now; 
		
		return vo;
	}
	
	/**
	 * 
	 * @param key
	 * @return
	 */
	synchronized public ValueObject removeValue(String key){
		return m_hm.remove(key);
	}

	/**
	 * 
	 * @return
	 */
	synchronized public DataTable getValueAll(){
		DataTable st = (DataTable)this.clone();
		
		long now = System.currentTimeMillis();
		m_lastReferenceInterval = now - m_lastReference;
		
		m_lastReference = System.currentTimeMillis();  // �����������
		return st;
	}
	
	protected Object clone(){
		DataTable st = new DataTable((HashMap)m_hm.clone(), this.m_lastReference);
		
		return st;
	}

	/**
	 * 
	 * @return
	 */
	public long getLastReference() {
		return m_lastReference;
	}
	
	/**
	 * 
	 * @return
	 */
	public long getLastReferenceInterval(){
		return m_lastReferenceInterval;
	}
	
	/**
	 * 
	 * @return
	 */
	public Set keySet(){
		return this.m_hm.keySet();
	}
}
