package org.postgresforest.apibase;

import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.*;
import java.util.concurrent.Callable;

import org.postgresforest.exception.ForestTaskNotExecutedException;

public final class PreparedStatementTask {
    
    public static final class Execute implements Callable<Boolean> {
        private final PreparedStatement pstmt;
        public Execute(PreparedStatement stmt) {
            this.pstmt = stmt;
        }
        public Boolean call() throws Exception {
            if (pstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Boolean.valueOf(pstmt.execute());
        }
    }
    
    public static final class ExecuteUpdate implements Callable<Integer> {
        private final PreparedStatement pstmt;
        public ExecuteUpdate(PreparedStatement stmt) {
            this.pstmt = stmt;
        }
        public Integer call() throws Exception {
            if (pstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return Integer.valueOf(pstmt.executeUpdate());
        }
    }
    
    public static final class ExecuteQuery implements Callable<ResultSet> {
        private final PreparedStatement pstmt;
        public ExecuteQuery(PreparedStatement stmt) {
            this.pstmt = stmt;
        }
        public ResultSet call() throws Exception {
            if (pstmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            return pstmt.executeQuery();
        }
    }
    
    public static final class ClearParameters implements Callable<Void> {
        private final PreparedStatement stmt;
        public ClearParameters(PreparedStatement stmt) {
            this.stmt = stmt;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.clearParameters();
            return null;
        }
    }
    
    public static final class SetAsciiStream implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final InputStream arg1;
        private final int arg2;
        public SetAsciiStream(PreparedStatement stmt, int arg0, InputStream arg1, int arg2) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setAsciiStream(arg0, arg1, arg2);
            return null;
        }
    }
    
    public static final class SetBigDecimal implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final BigDecimal arg1;
        public SetBigDecimal(PreparedStatement stmt, int arg0, BigDecimal arg1) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setBigDecimal(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetBinaryStream implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final InputStream arg1;
        private final int arg2;
        public SetBinaryStream(PreparedStatement stmt, int arg0, InputStream arg1, int arg2) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setBinaryStream(arg0, arg1, arg2);
            return null;
        }
    }
    
    public static final class SetBoolean implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final boolean arg1;
        public SetBoolean(PreparedStatement stmt, int arg0, boolean arg1) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setBoolean(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetByte implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final byte arg1;
        public SetByte(PreparedStatement stmt, int arg0, byte arg1) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setByte(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetBytes implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final byte[] arg1;
        public SetBytes(PreparedStatement stmt, int arg0, byte[] arg1) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = (arg1 != null) ? arg1.clone() : null;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setBytes(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetDate implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final java.sql.Date arg1;
        public SetDate(PreparedStatement stmt, int arg0, java.sql.Date arg1) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setDate(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetDouble implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final double arg1;
        public SetDouble(PreparedStatement stmt, int arg0, double arg1) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setDouble(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetFloat implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final float arg1;
        public SetFloat(PreparedStatement stmt, int arg0, float arg1) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setFloat(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetInt implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final int arg1;
        public SetInt(PreparedStatement stmt, int arg0, int arg1) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setInt(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetLong implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final long arg1;
        public SetLong(PreparedStatement stmt, int arg0, long arg1) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setLong(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetNull implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final int arg1;
        public SetNull(PreparedStatement stmt, int arg0, int arg1) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setNull(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetObject_IntObj implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final Object arg1;
        public SetObject_IntObj(PreparedStatement stmt, int arg0, Object arg1) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setObject(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetObject_IntObjInt implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final Object arg1;
        private final int arg2;
        public SetObject_IntObjInt(PreparedStatement stmt, int arg0, Object arg1, int arg2) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setObject(arg0, arg1, arg2);
            return null;
        }
    }
    
    public static final class SetShort implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final short arg1;
        public SetShort(PreparedStatement stmt, int arg0, short arg1) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setShort(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetString implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final String arg1;
        public SetString(PreparedStatement stmt, int arg0, String arg1) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setString(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetTime implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final Time arg1;
        public SetTime(PreparedStatement stmt, int arg0, Time arg1) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setTime(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetTimestamp implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final Timestamp arg1;
        public SetTimestamp(PreparedStatement stmt, int arg0, Timestamp arg1) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
        }
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setTimestamp(arg0, arg1);
            return null;
        }
    }
    
    public static final class SetUnicodeStream implements Callable<Void> {
        private final PreparedStatement stmt;
        private final int arg0;
        private final InputStream arg1;
        private final int arg2;
        public SetUnicodeStream(PreparedStatement stmt, int arg0, InputStream arg1, int arg2) {
            this.stmt = stmt;
            this.arg0 = arg0;
            this.arg1 = arg1;
            this.arg2 = arg2;
        }
        @SuppressWarnings("deprecation")
        public Void call() throws Exception {
            if (stmt == null) {
                throw new ForestTaskNotExecutedException();
            }
            stmt.setUnicodeStream(arg0, arg1, arg2);
            return null;
        }
    }
    
}
