package org.postgresforest.constant;

public enum LogStr {
    
    // SEVERE
    SEVERE_MNGINFO_SUPPLYCON_BOTHFAIL("両管理DBへのコネクション生成に失敗した"),
    SEVERE_MNGINFO_READDB_BOTHFAIL("管理情報を読み込む際、両系共情報読み出し・情報検証に何らかの問題が発生した"),
    SEVERE_BROKEN_SERVER("問題が発生したため縮退した serverid = "),
    SEVERE_MNGINFO_REFRESH_FAIL("管理情報定期更新タスクが何らかの問題で失敗"),
    SEVERE_MNGINFO_SUPPLYCON_ERROR("管理DBへのコネクション生成で致命的なエラーが発生した serverid = "),
    SEVERE_MNGINFO_READDB_ERROR("管理DBからの管理情報読み出し・情報検証中に致命的なエラーが発生した serverid = "),
    
    // WARNING
    WARN_MNGINFO_SUPPLYCON_CANCEL("制限時間内に管理DBへのコネクション生成が完了しなかった serverid = "),
    WARN_MNGINFO_SUPPLYCON_EXCEPTION("管理DBへのコネクション生成で何らかの問題が発生した serverid = "),
    WARN_MNGINFO_READDB_CANCEL("管理DBからの情報読み出しが制限時間内に完了しなかった serverid = "),
    WARN_MNGINFO_READDB_EXCEPTION("管理DBからの情報読み出し・情報検証時に何らかの問題が発生した serverid = "),
    
    // INFO
    INFO_MNGINFO_REFRESH_THREAD_START("管理情報定期更新スレッドの開始"),
    INFO_MNGINFO_REFRESH_THREAD_STOP("管理情報定期更新スレッドの正常終了"),
    INFO_MNGINFO_REFRESH_TASK_START("管理情報定期更新開始"),
    INFO_MNGINFO_REFRESH_TASK_END("管理情報定期更新正常終了"),
    INFO_MNGINFO_REFRESH_CONFLICT("管理情報定期更新タスクで管理情報の更新を試みたが、他スレッドでの管理情報更新タイミングと競合が発生した");
    
    private final String value;
    
    private LogStr(final String value) {
        this.value = value;
    }
    
    public String toString() {
        return value;
    }
}
