/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionFactory.IWorkbenchAction;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;

/**
 * ActionBarAdvisorクラスを継承するクラス<BR>
 * RCPのActionBarの設定などを行うクラス
 *  クライアントの表示に利用します。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class ClusterControlActionBarAdvisor extends ActionBarAdvisor {
	private IWorkbenchAction helpContentsAction;
	private IWorkbenchAction aboutAction;

	public ClusterControlActionBarAdvisor(IActionBarConfigurer configurer) {
		super(configurer);
	}

	@Override
	protected void makeActions(final IWorkbenchWindow window) {
		//ヘルプコンテンツアクション(org.eclipse.ui.internal.actions.HelpContentsAction)を作成
		helpContentsAction = ActionFactory.HELP_CONTENTS.create(window);
		register(helpContentsAction);
		
		//製品情報アクション(org.eclipse.ui.internal.about.AboutAction)を作成
        aboutAction = ActionFactory.ABOUT.create(window);
        register(aboutAction);
	}

	@Override
	protected void fillMenuBar(IMenuManager menuBar) {
		//ヘルプメニューを追加
		MenuManager helpMenu = new MenuManager(JFaceResources.getString("help"),
				IWorkbenchActionConstants.M_HELP);
		//製品情報用ヘルプメニューを追加
		MenuManager aboutMenu = new MenuManager(JFaceResources.getString("help"),
				IWorkbenchActionConstants.M_HELP + "_about");
		
		menuBar.add(new GroupMarker(IWorkbenchActionConstants.MB_ADDITIONS));
		menuBar.add(helpMenu);
		menuBar.add(aboutMenu);
		
		//ヘルプコンテンツアクションを追加
		helpMenu.add(helpContentsAction);
		
		//製品情報アクションを追加
		aboutMenu.add(aboutAction);
		
		//ヘルプメニューを非表示とする。（現状使用しないため）
		helpMenu.setVisible(false);
	}
}
