/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.accesscontrol.dialog;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.accesscontrol.action.GetUserFilterProperty;
import com.clustercontrol.bean.Property;
import com.clustercontrol.composite.PropertySheet;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;

/**
 * アクセス[ユーザのフィルタ処理]ダイアログクラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class UserFilterDialog extends CommonDialog {
	/** ユーザフィルタ用プロパティシート */
    private PropertySheet propertySheet = null;
    /** ユーザフィルタ用プロパティ */
    private static Property filterProperty = null;
    
    // 後でpackするためsizeXはダミーの値。
    private final int sizeX = 500;
    private final int sizeY = 500;
    
    /**
     * コンストラクタ
     * 
     * @param parent 親シェル
     */
    public UserFilterDialog(Shell parent) {
        super(parent);
    }

    /**
     * ダイアログの初期サイズを返します。
     * 
     * @return 初期サイズ
     * 
     * @see org.eclipse.jface.window.Window#getInitialSize()
     */
    @Override
	protected Point getInitialSize() {
        return new Point(sizeX, sizeY);
    }

    /**
     * ダイアログエリアを生成します。
     * 
     * @param parent 親コンポジット
     *            
     * @see com.clustercontrol.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
     */
    @Override
	protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // タイトル
        shell.setText(Messages.getString("dialog.accesscontrol.filter.users"));

        // レイアウト
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout(layout);

        /*
         * 属性プロパティシート
         */

        // ラベル
        Label label = new Label(parent, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("attribute") + " : ");

        // プロパティシート
        TableTree table = new TableTree(parent, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.MULTI | SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        this.propertySheet = new PropertySheet(table);

        // プロパティ設定
        if(filterProperty == null){
        	filterProperty = new GetUserFilterProperty().getProperty();
        }
        this.propertySheet.setInput(filterProperty);
        this.propertySheet.expandAll();

        // ラインを引く
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        line.setLayoutData(gridData);

        // 画面中央に
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
        shell.pack();
        shell.setSize(new Point(shell.getSize().x, sizeY));
    }

    /**
     * 入力値チェックをします。
     * 
     * @return 検証結果
     */
    @Override
	protected ValidateResult validate() {
        return super.validate();
    }

    /**
     * ユーザフィルタ用プロパティを返します。
     * 
     * @return ユーザフィルタ用プロパティ
     */
    public Property getInputData() {
    	if(filterProperty != null){
        	Property copy = PropertyUtil.copy(filterProperty);
            return copy;
    	}
    	else{
    		return null;
    	}
    }

    /**
     * 既存のボタンに加え、クリアボタンを追加します。
     * 
     * @param parent ボタンバーコンポジット
     * 
     * @see org.eclipse.jface.dialogs.Dialog#createButtonsForButtonBar(org.eclipse.swt.widgets.Composite)
     */
    @Override
	protected void createButtonsForButtonBar(Composite parent) {
    	// クリアボタン
    	this.createButton(parent, IDialogConstants.OPEN_ID, Messages
    			.getString("clear"), false);
    	this.getButton(IDialogConstants.OPEN_ID).addSelectionListener(
    			new SelectionAdapter() {
    				@Override
					public void widgetSelected(SelectionEvent e) {
    					// プロパティ設定
    			        filterProperty = new GetUserFilterProperty().getProperty();
    			        propertySheet.setInput(filterProperty);
    			        propertySheet.expandAll();
    				}
    			});
    	
    	super.createButtonsForButtonBar(parent);
    }

    /**
     * ＯＫボタンのテキストを返します。
     * 
     * @return ＯＫボタンのテキスト
     */
    @Override
	protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * キャンセルボタンのテキストを返します。
     * 
     * @return キャンセルボタンのテキスト
     */
    @Override
	protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }
}