/*
 
Copyright (C) 2009 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.accesscontrol.util;

import java.rmi.RemoteException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

import com.clustercontrol.action.FacilityTree;
import com.clustercontrol.repository.action.GetLastUpdate;
import com.clustercontrol.util.LoginManager;

public class LocalSession {

	/** ファシリティID更新用タイマー * */
	protected static Timer m_timer = null;

	/** リポジトリ最終更新時刻 */
	private static Date clientLastUpdate = null;

	/** マネージャへの疎通(Dummy)ポーリング周期（秒） */
	public static int m_managerPollingInterval = 1;

	/** 自分自身のインスタンス */
	private static LocalSession m_instance = null;

	/*:
	 * 
	 */
	public static LocalSession getLocalSession(){
		if(m_instance == null){
			m_instance = new LocalSession();
		}
		
		return m_instance;
	}

	/**
	 * コンストラクタ
	 */
	private LocalSession() {
		// 初回起動のデータはリフレッシュ必要がないため、起動時の時刻を入れる
		clientLastUpdate = new Date(System.currentTimeMillis());
		
	}
	
	
	// クライアント側で保持するローカル情報の削除処理
	public void clearSessionData() {
		// ファシリティツリーのローカルキャッシュをクリア
		//System.out.println("LocalSession.clearSessionData() start");
		FacilityTree.clearCache();
		//System.out.println("LocalSession.clearSessionData() stop");
	}

	/**
	 * 
	 * @return
	 */
	public Date getClientLastUpdate() {
		return clientLastUpdate;
	}

	/**
	 * 
	 * @param repositoryLastUpdate
	 */
	public void setClientLastUpdate(Date lastUpdate) {
		clientLastUpdate = lastUpdate;
	}

	/**
	 * チェックタスクを開始する
	 * 
	 * @param inverval 間隔(分)
	 */
	public void startChecktask(int interval) {
		//System.out.println("LocalSession.startChecktask() start : interval = " + interval);

		// タイマーが存在しない場合のみ実行
		if (m_timer == null && interval > 0) {
			//System.out.println("LocalSession.startChecktask() setup task");

			// タイマー作成
			m_timer = new Timer(true);

			// スケジュール設定
			m_timer.schedule(new SessionCheckTask(),
					interval * 60 * 1000,
					interval * 60 * 1000);
		}
	}

	/**
	 * チェックタスクをリスタートする
	 * 
	 * @param inverval 間隔(分)
	 */
	public void restartChecktask(int interval) {
		//System.out.println("LocalSession.restartChecktask() start : interval = " + interval);
		
		stopChecktask();
		
		startChecktask(interval);
	}
	
	
	/**
	 * チェックタスクを停止する
	 */
	public void stopChecktask() {
		//System.out.println("LocalSession.stopChecktask() start");

		if(m_timer != null){
			// スケジュール削除
			m_timer.cancel();

			// タイマー削除
			m_timer = null;
		}
		
	}

	/**
	 * 
	 */
	public void doCheck() {
		//System.out.println("LocalSession.doCheck() start");

		// ログインチェック
		//System.out.println("LocalSession.doCheck() Login Check");
		if(LoginManager.getContextManager().isLogin()){
			//System.out.println("LocalSession.doCheck() ログイン済み");
		}
		else{
			//System.out.println("LocalSession.doCheck() ログイン済みでない");
			return;
		}
		
		
		// リポジトリの最新更新時間を取得
		Date lastUpdate = null;
		//System.out.println("LocalSession.doCheck() Get Last Update");
		try{
			lastUpdate = (new GetLastUpdate()).getLastUpdate();
			
			//System.out.println("LocalSession.doCheck() lastUpdate = " + lastUpdate);
			//System.out.println("LocalSession.doCheck() clientLastUpdate = " + getClientLastUpdate());
		}catch (Exception e) {
			// マネージャ停止時			
			if(e instanceof NullPointerException){
				//System.out.println("LocalSession.doCheck() Manager is dead !!!!!!!!!!!!!!!!!!!!!!!!!!!");
				// ダイアログを表示する
				LoginManager.getContextManager().disconnectManager();
			}
			// アクセス権限(RepositoryRead)がない=ありえない場合
			else if(e instanceof RemoteException){
				e.printStackTrace();
			}
			// 想定外の例外
			else {
				e.printStackTrace();
			}
			return;
		}

		//System.out.println("LocalSession.doCheck() Do Repository Update");
		if (lastUpdate != null && getClientLastUpdate() != null) {
			// リポジトリの最新更新時刻が古い場合にキャッシュ更新
			//System.out.println("LocalSession.doCheck() getClientLastUpdate().compareTo(lastUpdate) = " + getClientLastUpdate().compareTo(lastUpdate));
			if (getClientLastUpdate().compareTo(lastUpdate) < 0) {
				//System.out.println("LocalSession.doCheck() update");

				// 最終更新時刻を更新
				setClientLastUpdate(lastUpdate);

				// リポジトリツリーキャッシュを更新して画面を再描画する
				FacilityTree.reflesh();
			}
		}
	}

	/**
	 * EJB接続確認タイマータスク 通信エラーとなった場合はダイアログを表示する
	 */
	protected class SessionCheckTask extends TimerTask {

		@Override
		public void run() {
			// TODO Auto-generated method stub
			//System.out.println("SessionCheckTask.run() start at Date : " + (new Date()).toString());
			doCheck();
		}
	}
}
