/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.calendar.bean.WeekdayListTableDefine;
import com.clustercontrol.util.Messages;

/**
 * カレンダ曜日別情報一覧テーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetWeekdayInfoListTableDefine {

    // ----- instance メソッド ----- //

    /**
     * カレンダ曜日別情報一覧テーブル定義を取得します。<BR>
     * 
     * @return
     */
    public static ArrayList<TableColumnInfo> get() {
		//テーブル定義配列
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
		Locale locale = Locale.getDefault();
		
		tableDefine.add(WeekdayListTableDefine.WEEKDAY, 
				new TableColumnInfo(Messages.getString("weekday", locale), TableColumnInfo.DAY_OF_WEEK, 80, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.TIME_FROM, 
				new TableColumnInfo(Messages.getString("timestamp", locale) + "(" + Messages.getString("start", locale) + ")", 
						TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.TIME_TO, 
				new TableColumnInfo(Messages.getString("timestamp", locale) + "(" + Messages.getString("end", locale) + ")", 
						TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.DESCRIPTION, 
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.CREATOR_NAME, 
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.CREATE_TIME, 
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.MODIFIER_NAME, 
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(WeekdayListTableDefine.MODIFY_TIME, 
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));

		return tableDefine;
    }
}