/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.calendar.composite.action;

import java.util.ArrayList;

import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.StructuredSelection;

import com.clustercontrol.accesscontrol.bean.UserListTableDefine;
import com.clustercontrol.accesscontrol.composite.UserListComposite;
import com.clustercontrol.accesscontrol.dialog.UserDetailDialog;

/**
 * ユーザ一覧テーブルのDoubleClickListenerクラス<BR>
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class UserDoubleClickListener implements IDoubleClickListener {
    protected UserListComposite m_composite;

    /**
     * コンストラクタ
     * 
     * @param composite
     * @since 2.0.0
     */
    public UserDoubleClickListener(UserListComposite composite) {
        m_composite = composite;
    }
    
	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IDoubleClickListener#doubleClick(org.eclipse.jface.viewers.DoubleClickEvent)
	 */
	public void doubleClick(DoubleClickEvent event) {
		String uid = null;
		
        //UIDを取得
        if (((StructuredSelection) event.getSelection()).getFirstElement() != null) {
            ArrayList info = (ArrayList) ((StructuredSelection) event
                    .getSelection()).getFirstElement();
            uid = (String) info.get(UserListTableDefine.UID);
        }
        
        if(uid != null){
            // ダイアログを生成
            UserDetailDialog dialog = new UserDetailDialog(m_composite.getShell(), uid);

            // ダイアログにて変更が選択された場合、入力内容をもって登録を行う。
            dialog.open();
        }
	}

}
