/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.composite.action;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;

import com.clustercontrol.collectiverun.bean.CommandInfo;
import com.clustercontrol.collectiverun.bean.CommandParameterInfo;
import com.clustercontrol.collectiverun.bean.CommandTypeConstant;
import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.ParameterInfo;
import com.clustercontrol.collectiverun.bean.ParameterSelectInfo;
import com.clustercontrol.collectiverun.bean.ParameterTypeConstant;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.bean.TypeInfo;
import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.util.Messages;

/**
 * 一括制御階層ツリー作成のSelectionListenerクラス
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class CreateTreeItemSelectionListener extends BaseTreeItemSelectionListener {

    /**
     * コンストラクタ
     * 
     * @param composite
     */
    public CreateTreeItemSelectionListener(TreeComposite composite) {
    	super(composite);
    }

    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
     */
    @Override
	public void widgetSelected(SelectionEvent e) {
    	
    	//作成中アイテムのチェック
    	if(!checkCreateItem())
    		return;
    	
    	//更新中アイテムのチェック
    	if(!checkUpdateItem())
    		return;
    	
    	TreeItem item = null;
    	TreeItem parent = null;
    	
    	parent = this.composite.getSelectItem();
    	
    	if (parent instanceof TreeItem) {
    		ItemInfo parentInfo = parent.getInfo();
    		
    		int maxOrderNo = TreeItemUtil.getMaxOrderNo(parent);
    		
    		ItemInfo info = null;
    		if(parentInfo.getType() == ItemConstant.TYPE_COMMADN_COMPOSITE){
    			info = new TypeInfo();
    			info.setType(ItemConstant.TYPE_TYPE);
    			info.setOrderNo(maxOrderNo + 1);
    			info.setName(Messages.getString("new.creating"));
    		}
    		else if(parentInfo.getType() == ItemConstant.TYPE_PARAMETER_COMPOSITE){
    			info = new ParameterInfo();
    			info.setType(ItemConstant.TYPE_PARAMETER);
    			info.setOrderNo(maxOrderNo + 1);
    			info.setName(Messages.getString("new.creating"));
    			((ParameterInfo)info).setParamType(ParameterTypeConstant.TYPE_STRING);
    		}
    		else if(parentInfo.getType() == ItemConstant.TYPE_TYPE){
    			info = new CommandInfo();
    			info.setType(ItemConstant.TYPE_COMMAND);
    			info.setOrderNo(maxOrderNo + 1);
    			info.setName(Messages.getString("new.creating"));
    			((CommandInfo)info).setCommandType(CommandTypeConstant.TYPE_COMMAND);
    		}
    		else if(parentInfo.getType() == ItemConstant.TYPE_COMMAND){
    			info = new CommandParameterInfo();
    			info.setType(ItemConstant.TYPE_COMMAND_PARAMETER);
    			info.setOrderNo(maxOrderNo + 1);
    			info.setName(Messages.getString("new.creating"));
    		}
    		else if(parentInfo.getType() == ItemConstant.TYPE_COMMAND_PARAMETER){
    			return ;
    		}
    		else if(parentInfo.getType() == ItemConstant.TYPE_PARAMETER){
    			info = new ParameterSelectInfo();
    			info.setType(ItemConstant.TYPE_SELECT_ITEM);
    			info.setOrderNo(maxOrderNo + 1);
    			info.setName(Messages.getString("new.creating"));
    			((ParameterSelectInfo)info).setId(((ParameterInfo)parentInfo).getId());
    		}
    		else if(parentInfo.getType() == ItemConstant.TYPE_SELECT_ITEM){
    			return ;
    		}
    		item = new TreeItem(parent, info);

    		this.composite.setCreateItem(item);
    		this.composite.getTreeViewer().refresh(parent);
    		this.composite.getTreeViewer().setSelection(
    				new StructuredSelection(item), true);
    	}
    }
}

