/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.jobmanagement.bean.ForwardFileTableDefine;
import com.clustercontrol.util.Messages;

/**
 * ジョブ[ファイル転送]ビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、テーブル定義を取得します。
 *
 * @version 2.0.0
 * @since 2.0.0
 */
public class GetForwardFileTableDefine {

	/**
	 * マネージャにSessionBean経由でアクセスし、
	 * ジョブ[ファイル転送]ビューのテーブル定義を取得します。<BR>
	 * 
	 * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
	 */
	public static ArrayList<TableColumnInfo> get() {
		//テーブル定義配列
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
		Locale locale = Locale.getDefault();
		
		tableDefine.add(ForwardFileTableDefine.STATUS, 
				new TableColumnInfo(Messages.getString("run.status", locale), TableColumnInfo.STATE, 80, SWT.LEFT));
		tableDefine.add(ForwardFileTableDefine.END_STATUS, 
				new TableColumnInfo(Messages.getString("end.status", locale), TableColumnInfo.END_STATUS, 80, SWT.LEFT));
		tableDefine.add(ForwardFileTableDefine.FILE_NAME, 
				new TableColumnInfo(Messages.getString("file", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(ForwardFileTableDefine.SRC_FACILITY_ID, 
				new TableColumnInfo(Messages.getString("forward.source", locale) + Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(ForwardFileTableDefine.SRC_FACILITY_NAME, 
				new TableColumnInfo(Messages.getString("forward.source", locale) + Messages.getString("facility.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(ForwardFileTableDefine.DEST_FACILITY_ID, 
				new TableColumnInfo(Messages.getString("forward.destination", locale) + Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(ForwardFileTableDefine.DEST_FACILITY_NAME, 
				new TableColumnInfo(Messages.getString("forward.destination", locale) + Messages.getString("facility.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(ForwardFileTableDefine.START_RERUN_TIME, 
				new TableColumnInfo(Messages.getString("start.rerun.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(ForwardFileTableDefine.END_SUSPEND_TIME, 
				new TableColumnInfo(Messages.getString("end.suspend.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));

		return tableDefine;
	}
}
