/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.JobInfoNotFoundException;
import com.clustercontrol.JobMasterNotFoundException;
import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.jobmanagement.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ジョブ[ジョブ詳細]ビューの一覧情報を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、ジョブ詳細一覧情報を取得する
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetJobDetail {
	
	/**
	 * マネージャにSessionBean経由でアクセスし、ジョブ詳細一覧情報を取得する
	 * 
	 * @return ジョブ詳細一覧情報
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobController
	 * @see com.clustercontrol.jobmanagement.util.EjbConnectionManager
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerBean#getDetailList(java.lang.String)
	 */
	public CommonTableTreeItem getJobDetail(String sessionId) {
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();
		
		CommonTableTreeItem item = null;
		try {
			item = job.getDetailList(sessionId);
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
		} catch (HinemosUnknownException e) {
			e.printStackTrace();
		} catch (JobInfoNotFoundException e) {
			e.printStackTrace();
		} catch (JobMasterNotFoundException e) {
			e.printStackTrace();
		}
		
		return item;
	}
}
