/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.jobmanagement.bean.JobDetailTableDefine;
import com.clustercontrol.util.Messages;

/**
 * ジョブ[ジョブ詳細]ビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、テーブル定義を取得する
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetJobDetailTableDefine {
	
	/**
	 * マネージャにSessionBean経由でアクセスし、<BR>
	 * ジョブ[ジョブ詳細]ビューのテーブル定義を取得する
	 * 
	 * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
	 */
	public static ArrayList<TableColumnInfo> get() {
		//テーブル定義配列
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
		Locale locale = Locale.getDefault();
		
		tableDefine.add(JobDetailTableDefine.TREE, 
				new TableColumnInfo("", TableColumnInfo.NONE, 30, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.STATUS, 
				new TableColumnInfo(Messages.getString("run.status", locale), TableColumnInfo.STATE, 80, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.END_STATUS, 
				new TableColumnInfo(Messages.getString("end.status", locale), TableColumnInfo.END_STATUS, 80, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.END_VALUE, 
				new TableColumnInfo(Messages.getString("end.value", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.JOB_ID, 
				new TableColumnInfo(Messages.getString("job.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.JOB_NAME, 
				new TableColumnInfo(Messages.getString("job.name", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.JOBUNIT_ID, 
				new TableColumnInfo(Messages.getString("jobunit.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.JOB_TYPE, 
				new TableColumnInfo(Messages.getString("type", locale), TableColumnInfo.JOB, 110, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.SCOPE, 
				new TableColumnInfo(Messages.getString("scope", locale), TableColumnInfo.FACILITY, 150, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.WAIT_RULE_TIME, 
				new TableColumnInfo(Messages.getString("wait.rule.time", locale), TableColumnInfo.NONE, 120, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.START_RERUN_TIME, 
				new TableColumnInfo(Messages.getString("start.rerun.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(JobDetailTableDefine.END_SUSPEND_TIME, 
				new TableColumnInfo(Messages.getString("end.suspend.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));

		return tableDefine;
	}
}
