/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.jobmanagement.bean.NodeDetailTableDefine;
import com.clustercontrol.util.Messages;

/**
 * ジョブ[ノード詳細]ビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、テーブル定義を取得する
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetNodeDetailTableDefine {
	
	/**
	 * マネージャにSessionBean経由でアクセスし、<BR>
	 * ジョブ[ノード詳細]ビューのテーブル定義を取得する
	 * 
	 * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
	 */
	public static ArrayList<TableColumnInfo> get() {
		//テーブル定義配列
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
		Locale locale = Locale.getDefault();

		tableDefine.add(NodeDetailTableDefine.STATUS, 
				new TableColumnInfo(Messages.getString("run.status", locale), TableColumnInfo.STATE, 80, SWT.LEFT));
		tableDefine.add(NodeDetailTableDefine.RETURN_VALUE, 
				new TableColumnInfo(Messages.getString("return.value", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
		tableDefine.add(NodeDetailTableDefine.FACILITY_ID, 
				new TableColumnInfo(Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(NodeDetailTableDefine.FACILITY_NAME, 
				new TableColumnInfo(Messages.getString("facility.name", locale), TableColumnInfo.FACILITY, 150, SWT.LEFT));
		tableDefine.add(NodeDetailTableDefine.START_RERUN_TIME, 
				new TableColumnInfo(Messages.getString("start.rerun.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(NodeDetailTableDefine.END_SUSPEND_TIME, 
				new TableColumnInfo(Messages.getString("end.suspend.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(NodeDetailTableDefine.MESSAGE, 
				new TableColumnInfo(Messages.getString("message", locale), TableColumnInfo.TEXT_DIALOG, 300, SWT.LEFT));
		
		return tableDefine;
	}
}
