/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.jobmanagement.bean.ScheduleTableDefine;
import com.clustercontrol.util.Messages;

/**
 * ジョブ[スケジュール]ビューのテーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、テーブル定義を取得する
 *
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetScheduleTableDefine {
	
	/**
	 * マネージャにSessionBean経由でアクセスし、<BR>
	 * ジョブ[スケジュール]ビューのテーブル定義を取得する
	 * 
	 * @return テーブル定義情報（{@link com.clustercontrol.bean.TableColumnInfo}のリスト）
	 */
	public static ArrayList<TableColumnInfo> get() {
		//テーブル定義配列
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
		Locale locale = Locale.getDefault();

		tableDefine.add(ScheduleTableDefine.SCHE_ID, 
				new TableColumnInfo(Messages.getString("schedule.id", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.SCHE_NAME, 
				new TableColumnInfo(Messages.getString("schedule.name", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.JOB_ID, 
				new TableColumnInfo(Messages.getString("job.id", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.JOB_NAME, 
				new TableColumnInfo(Messages.getString("job.name", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.JOBUNIT_ID, 
				new TableColumnInfo(Messages.getString("jobunit.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.CALENDAR_ID, 
				new TableColumnInfo(Messages.getString("calendar.id", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.SCHEDULE, 
				new TableColumnInfo(Messages.getString("schedule", locale), TableColumnInfo.SCHEDULE, 100, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.VALID, 
				new TableColumnInfo(Messages.getString("valid", locale) + "/" + Messages.getString("invalid", locale), TableColumnInfo.VALID, 100, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.CREATE_USER, 
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.CREATE_TIME, 
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.UPDATE_USER, 
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		tableDefine.add(ScheduleTableDefine.UPDATE_TIME, 
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 150, SWT.LEFT));

		return tableDefine;

	}
}
