/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.JobInvalidException;
import com.clustercontrol.JobMasterNotFoundException;
import com.clustercontrol.NotifyNotFoundException;
import com.clustercontrol.jobmanagement.bean.JobTreeItem;
import com.clustercontrol.jobmanagement.ejb.session.JobController;
import com.clustercontrol.jobmanagement.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * ジョブ[一覧]ビューのジョブツリー情報を登録するクライアント側アクションクラス<BR>
 * 
 * マネージャにSessionBean経由でアクセスし、ジョブツリー情報を登録する
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class RegisterJob {
	
	/**
	 * マネージャにSessionBean経由でアクセスし、ジョブツリー情報を登録する
	 * 
	 * @param item ジョブツリー情報
	 * @return true=成功、false=失敗
	 * 
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobController
	 * @see com.clustercontrol.jobmanagement.util.EjbConnectionManager
	 * @see com.clustercontrol.jobmanagement.ejb.session.JobControllerBean#registerJob(com.clustercontrol.jobmanagement.bean.JobTreeItem)
	 */
	public boolean registerJob(JobTreeItem item) {
		boolean result = false;
		
		JobController job = 
			EjbConnectionManager.getConnectionManager().getJobController();
		
		try {
			
			// ジョブ登録(ID重複結果、待ち条件チェックにERRORがある場合は例外発生)
			job.registerJob(item);
			
			result = true;
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// アクセス権なしの場合、エラーダイアログを表示する
				MessageDialog.openInformation(null, Messages.getString("message"),
						Messages.getString("message.accesscontrol.16"));
			}
		} catch (HinemosUnknownException e) {
			e.printStackTrace();
		} catch (JobMasterNotFoundException e) {
			e.printStackTrace();
		} catch (JobInvalidException e) {
			MessageDialog.openWarning(
					null, 
					Messages.getString("message.hinemos.1"), 
					e.getMessage());
		}
		return result;
	}
}
