/*
 
Copyright (C) 2010 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.composite;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;


import com.clustercontrol.bean.SizeConstant;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.action.GetManagementUserTableDefine;
import com.clustercontrol.jobmanagement.bean.JobManagementUserInfo;
import com.clustercontrol.jobmanagement.bean.ManagementUserTableDefine;
import com.clustercontrol.jobmanagement.dialog.UserDialog;
import com.clustercontrol.util.Messages;

/**
 * ジョブユニットの管理ユーザを設定を行うダイアログコンポジット
 * @author Hinemos
 *
 */
public class ManagementUserComposite extends Composite {

	/** テーブルビューア */
	protected CommonTableViewer m_viewer = null;
    /** 全ユーザ参照可能ラジオボタン */
    protected Button m_allUserSelection = null;
    /** 参照ユーザ指定ラジオボタン */
    protected Button m_fixedUserSelection = null;
	/** 設定ボタン */
	protected Button m_setupCondition = null;
	/** 参照ユーザ一覧テーブル */
	protected Table m_table = null;
	/** 参照ユーザ指定可否 */
	protected boolean m_isAll = false;
	/** ユーザ情報のリスト */
	protected ArrayList<JobManagementUserInfo> m_userList = null;
	/** シェル */
	protected Shell m_shell = null;
	
	/**
	 * コンストラクタ
	 * 
     * @param parent 親のコンポジット
     * @param style スタイル
	 */
	public ManagementUserComposite(Composite parent, int style) {
		super(parent, style);
		initialize();
		m_shell = this.getShell();
	}
	
	/**
	 * コンポジットを構築します。
	 */
	private void initialize() {
		RowLayout layout = new RowLayout();
		layout.type = SWT.VERTICAL;
		layout.spacing = 1;
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.fill = true;
		this.setLayout(layout);
		
		Composite composite = null;
		RowLayout rowLayout = null;
		
		composite = new Composite(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		composite.setLayout(rowLayout);

		//全ユーザ参照可能ラジオボタン
		m_allUserSelection = new Button(composite, SWT.RADIO);
		m_allUserSelection.setText(Messages.getString("job.jobunit.visible.alluser"));
		m_allUserSelection.setLayoutData(
        		new RowData(300, SizeConstant.SIZE_BUTTON_HEIGHT));
		m_allUserSelection.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				Button check = (Button) e.getSource();
				if (check.getSelection()) {
					userSelect(true);
				}
			}
			public void widgetDefaultSelected(SelectionEvent e) {
			}
		});
		
		//参照可能ユーザ指定ラジオボタン
		m_fixedUserSelection = new Button(composite, SWT.RADIO);
		m_fixedUserSelection.setText(Messages.getString("job.jobunit.visible.fixeduser"));
		m_fixedUserSelection.setLayoutData(
        		new RowData(300, SizeConstant.SIZE_BUTTON_HEIGHT));
		m_fixedUserSelection.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				Button check = (Button) e.getSource();
				if (check.getSelection()) {
					userSelect(false);
				}
			}
			public void widgetDefaultSelected(SelectionEvent e) {
			}
		});
		
		composite = new Composite(this, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.VERTICAL;
		composite.setLayout(rowLayout);

		
		Label tableTitle = new Label(composite, SWT.NONE);
		tableTitle.setText(Messages.getString("list"));
		
		m_table = new Table(composite, SWT.BORDER | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.SINGLE);
		m_table.setHeaderVisible(true);
		m_table.setLinesVisible(true);
		m_table.setLayoutData(new RowData(430, 80));
		
		composite = new Composite(composite, SWT.NONE);
		rowLayout = new RowLayout();
		rowLayout.type = SWT.HORIZONTAL;
		rowLayout.spacing = 5;
		composite.setLayout(rowLayout);
		
		//設定ボタン
		Label dummy1 = new Label(composite, SWT.NONE);
		dummy1.setLayoutData(new RowData(350, SizeConstant.SIZE_LABEL_HEIGHT));
		m_setupCondition = new Button(composite, SWT.NONE);
		m_setupCondition.setText(Messages.getString("setup"));
		m_setupCondition.setLayoutData(new RowData(80,
				SizeConstant.SIZE_BUTTON_HEIGHT));
		m_setupCondition.addSelectionListener(new SelectionAdapter() {
			@Override
			@SuppressWarnings("unchecked")
			public void widgetSelected(SelectionEvent e) {
				UserDialog dialog = new UserDialog(m_userList, m_shell);
				if (dialog.open() == IDialogConstants.OK_ID) {
					// 更新
					ArrayList<JobManagementUserInfo> userList = dialog.getSelectionData();
					setUserInfo(userList);
					reflectUserInfo();
				}
			}
		});
		
		m_viewer = new CommonTableViewer(m_table);
		m_viewer.createTableColumn(GetManagementUserTableDefine.get(),
				ManagementUserTableDefine.SORT_COLUMN_INDEX,
				ManagementUserTableDefine.SORT_ORDER);
	}

	/**
	 * 全てのユーザから参照可能とするか否かの表示・フラグ切り替え
	 * @param isAll
	 */
	private void userSelect(boolean isAll){
		
		// フラグ更新
		m_isAll = isAll;
		
		// 表示内容更新
		if(isAll){
			m_allUserSelection.setSelection(true);
			m_fixedUserSelection.setSelection(false);
			
			m_table.setEnabled(false);
			m_setupCondition.setEnabled(false);
		} else {
			m_allUserSelection.setSelection(false);
			m_fixedUserSelection.setSelection(true);
			
			m_table.setEnabled(true);
			m_setupCondition.setEnabled(true);
		}
	}
	
	/**
	 * ユーザ情報の切り替え
	 * @param userInfo
	 */
	public void setUserInfo(ArrayList<JobManagementUserInfo> userInfo) {
		m_userList = userInfo;
	}
	
	/**
	 * 管理情報をコンポジットに反映します。
	 */
	public void reflectUserInfo() {
		
		// 管理ユーザ一覧テーブル更新
		if(m_userList != null){
			userSelect(false);
			
			//パラメータ設定
			ArrayList<ArrayList<String>> tableData = new ArrayList<ArrayList<String>>();
			for (int i = 0; i < m_userList.size(); i++) {
				JobManagementUserInfo data = m_userList.get(i);
				ArrayList tableLineData = new ArrayList();
				tableLineData.add(data.getUserId());
				tableLineData.add(data.getUserName());
				tableLineData.add(data.getDescription());
				tableData.add(tableLineData);
			}
			m_viewer.setInput(tableData);
			m_viewer.refresh();
		}
		
		// 表示内容更新
		if(m_userList != null && m_userList.size() != 0){
			userSelect(false);		
		} else {
			userSelect(true);
		}
	}
	
	/**
	 * OKボタン押下時のvalidate
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public ValidateResult createUserInfo() {
		ValidateResult result = null;
		
		// ユーザ指定のラジオボタン選択にも関わらずユーザリストが0の場合
		if(!m_isAll && ((m_userList == null) || (m_userList.size() == 0))){
            result = new ValidateResult();
            result.setValid(false);
            result.setID(Messages.getString("message.hinemos.1"));
            result.setMessage(Messages.getString("message.job.63"));
            return result;
		}
		
		return result;
	}
	
	/**
	 * ユーザ情報の返却
	 * @return
	 */
	public ArrayList<JobManagementUserInfo> getUserInfo() {
		if(m_isAll){
			return null;
		} else {
			return m_userList;
		}
	}
}
