/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ui;

import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;

import com.clustercontrol.ClusterControlPerspectiveBase;
import com.clustercontrol.jobmanagement.view.ForwardFileView;
import com.clustercontrol.jobmanagement.view.JobDetailView;
import com.clustercontrol.jobmanagement.view.JobHistoryView;
import com.clustercontrol.jobmanagement.view.JobListView;
import com.clustercontrol.jobmanagement.view.JobNodeDetailView;
import com.clustercontrol.jobmanagement.view.RunScheduleDetailListView;
import com.clustercontrol.jobmanagement.view.RunScheduleListView;
import com.clustercontrol.jobmanagement.view.ScheduleListView;

/**
 * ジョブ管理のパースペクティブを生成するクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class JobManagementPerspective extends ClusterControlPerspectiveBase {

    /**
     * 画面レイアウトを実装します。
     * 
     * @see org.eclipse.ui.IPerspectiveFactory#createInitialLayout(org.eclipse.ui.IPageLayout)
     */
    @Override
	public void createInitialLayout(IPageLayout layout) {
    	super.createInitialLayout(layout);
    	
        //エディタ領域のIDを取得
        String editorArea = layout.getEditorArea();
        //エディタ領域の上部80%を占めるフォルダを作成
        IFolderLayout top = layout.createFolder("top", IPageLayout.TOP,
                0.66f, editorArea);
        //ID=topのフォルダの左側50%を占めるフォルダの作成
        IFolderLayout middle = layout.createFolder("middle",
                IPageLayout.BOTTOM, 0.5f, "top");
        //エディタ領域の下部30%を占めるフォルダを作成
        IFolderLayout bottom = layout.createFolder("bottom",
                IPageLayout.BOTTOM, 0.34f, editorArea);
        top.addView(JobListView.ID);
        top.addView(ScheduleListView.ID);
        top.addView(JobHistoryView.ID);
        top.addView(RunScheduleListView.ID);
        middle.addView(JobDetailView.ID);
        middle.addView(RunScheduleDetailListView.ID);
        bottom.addView(JobNodeDetailView.ID);
        bottom.addView(ForwardFileView.ID);
    }
}