/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.view;

import java.util.Calendar;
import java.util.Date;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.clustercontrol.jobmanagement.composite.RunScheduleComposite;
import com.clustercontrol.jobmanagement.composite.RunScheduleListComposite;
import com.clustercontrol.view.CommonViewPart;

/**
 * ジョブ[実行予定]ビュークラスです。
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class RunScheduleListView extends CommonViewPart {
	/** ビューID */
	public static final String ID = "com.clustercontrol.jobmanagement.view.RunScheduleListView";
	/** サッシュ */
	private SashForm m_sash = null;
	/** ジョブ[実行予定]ビューの左側用のコンポジット */
    private RunScheduleListComposite m_runScheduleList = null;
    /** ジョブ[実行予定]ビューの右側用のコンポジット */
	private RunScheduleComposite m_runSchedule = null;
	/** 基準日 */
    protected Date m_base = null;
	
    /**
     * コンストラクタ
     */
    public RunScheduleListView() {
        super();
    }

    /**
     * ビューを構築します。
     * 
     * @param parent 親コンポジット
     * 
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     * @see #update()
     */
    @Override
	public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

		// サッシュフォーム作成及び設定
        m_sash = new SashForm(parent, SWT.HORIZONTAL);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		m_sash.setLayoutData(gridData);
		
        m_runScheduleList = new RunScheduleListComposite(m_sash, SWT.NONE);

        Calendar baseCalendar = Calendar.getInstance();
        baseCalendar.setTime(new Date());
        baseCalendar.add(Calendar.WEEK_OF_MONTH, -1);
        m_base = new Date();
        m_runSchedule = new RunScheduleComposite(m_sash, SWT.NONE, baseCalendar.getTime());
        
		// Sashの境界を調整 左部50% 右部50%
//        m_sash.setWeights(new int[] { 50, 50 });

        //ビューを更新
        this.update();
    }

    /**
     * ビューを更新します。
     * 
     * @see com.clustercontrol.jobmanagement.composite.RunScheduleListComposite#update()
     * @see com.clustercontrol.jobmanagement.composite.RunScheduleComposite#update()
     * @see #createScheduleComposite()
     */
    public void update() {
    	m_runScheduleList.update();
    	
    	if(!m_base.equals(m_runSchedule.getBaseDate())){
    		//ScheduleComposite作成
    		createScheduleComposite();
    	}
    	
    	m_runSchedule.update();
    }
    
    /**
     * ジョブ[実行予定]ビューの右側用のコンポジットを基準日を元に再作成します。
     */
    public void createScheduleComposite() {
		//ScheduleComposite解放
    	m_runSchedule.dispose();
		
        m_runSchedule = new RunScheduleComposite(m_sash, SWT.NONE, m_base);
	    
	    //SashForm再描画
        m_sash.layout(true, true);
    }
    
	/**
	 * ジョブ[実行予定]ビューの左側用のコンポジットを返します。
	 * 
	 * @return ジョブ[実行予定]ビューの左側用のコンポジット
	 */
	public RunScheduleListComposite getListComposite() {
		return m_runScheduleList;
	}
	
	/**
	 * ジョブ[実行予定]ビューの右側用のコンポジットを返します。
	 * 
	 * @return ジョブ[実行予定]ビューの右側用のコンポジット
	 */
	public RunScheduleComposite getScheduleComposite() {
		return m_runSchedule;
	}
    
	/**
	 * ジョブ[実行予定]ビューの右側用のコンポジットを表示します。
	 */
	public void showSchedule() {
		m_sash.setMaximizedControl(null);
	}
	
	/**
	 * ジョブ[実行予定]ビューの右側用のコンポジットを非表示にします。
	 */
	public void hideSchedule() {
		m_sash.setMaximizedControl(m_runScheduleList);
	}
    
	/**
	 * 基準日を返します。
	 * 
	 * @return 基準日
	 */
	public Date getBaseDate() {
		return m_base;
	}
	
	/**
	 * 基準日を設定します。
	 * 
	 * @param base 基準日
	 */
	public void setBaseDate(Date base) {
		m_base = base;
	}
}