/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.action;

import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.quartz.SchedulerException;


import com.clustercontrol.HinemosUnknownException;
import com.clustercontrol.NotifyNotFoundException;
import com.clustercontrol.maintenance.ejb.session.MaintenanceController;
import com.clustercontrol.maintenance.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.maintenance.bean.MaintenanceInfoDataImp;

/**
 * メンテナンス情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 3.0.0
 * @since 2.2.0
 */
public class GetMaintenance {

	
	/**
	 * メンテナンス情報を返します。
	 * 
	 * @param maintenanceId
	 * @return
	 */
	public MaintenanceInfoDataImp getMaintenanceInfo(String maintenanceId) {
		
    	MaintenanceController maintenance = EjbConnectionManager.getConnectionManager().getMaintenanceController();
    	MaintenanceInfoDataImp info = null;
    	
		try {
			info = maintenance.getMaintenanceInfo(maintenanceId);
		} catch (RemoteException e) {
			// アクセス権なしの場合、エラーダイアログを表示する
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		} catch (FinderException e) {
			e.printStackTrace();
		} catch (NamingException e) {
			e.printStackTrace();
		} catch (CreateException e) {
			e.printStackTrace();
		} catch (HinemosUnknownException e) {
			e.printStackTrace();
		} catch (NotifyNotFoundException e) {
			e.printStackTrace();
		}
    	return info;
	}
    
    /**
     * メンテナンス一覧を返します。
     * 
     * @return メンテナンス一覧
     */
    public ArrayList getMaintenanceList() {

    	MaintenanceController maintenance = EjbConnectionManager.getConnectionManager().getMaintenanceController();
    	ArrayList records = null;
    	try {
			records = maintenance.getMaintenanceList();
		} catch (RemoteException e) {
			// アクセス権なしの場合、エラーダイアログを表示する
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		} catch (FinderException e) {
		} catch (NamingException e) {
		} catch (CreateException e) {
		} catch (SchedulerException e) {
		}
    	return records;
    }
    
    /**
     * メンテナンス種別一覧をマネージャより取得する
     * @return　ArrayList
     */
    public ArrayList getMaintenanceTypeList() {
    	
    	MaintenanceController maintenance = EjbConnectionManager.getConnectionManager().getMaintenanceController();
    	ArrayList records = null;
    	
		try {
			records = maintenance.getMaintenanceTypeList();
		} catch (RemoteException e) {
			// アクセス権なしの場合、エラーダイアログを表示する
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		} catch (FinderException e) {
		} catch (NamingException e) {
		} catch (CreateException e) {
		}
		
		return records;		
    }
    
    /**
     * 保存期間一覧をマネージャより取得する
     * @return ArrayList
     */
    public ArrayList getMaintenanceKeepList() {
    	
    	MaintenanceController maintenance = EjbConnectionManager.getConnectionManager().getMaintenanceController();
    	ArrayList records = null;
    	
		try {
			records = maintenance.getMaintenanceKeepList();
		} catch (RemoteException e) {
			// アクセス権なしの場合、エラーダイアログを表示する
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		} catch (FinderException e) {
		} catch (NamingException e) {
		} catch (CreateException e) {
		}
		
		return records;		
    }
}