/*
 
Copyright (C) 2007 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.maintenance.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.maintenance.bean.MaintenanceTableDefine;
import com.clustercontrol.util.Messages;

/**
 * メンテナンス一覧テーブル定義情報を取得するクライアント側アクションクラス<BR>
 * 
 * @version 2.2.0
 * @since 2.2.0
 */
public class GetMaintenanceListTableDefine {

    /**
     * メンテナンス一覧のテーブル定義情報を返します。
     * 
     * @return メンテナンス一覧テーブル定義情報
     */
    public static ArrayList<TableColumnInfo> get() {
		/** テーブル情報定義配列 */
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
		Locale locale = Locale.getDefault();

		tableDefine.add(MaintenanceTableDefine.MAINTENANCE_ID,
				new TableColumnInfo(Messages.getString("maintenance.id", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		
		tableDefine.add(MaintenanceTableDefine.DESCRIPTION,
				new TableColumnInfo(Messages.getString("description", locale), TableColumnInfo.NONE, 200, SWT.LEFT));
		
		tableDefine.add(MaintenanceTableDefine.TYPE_ID,
				new TableColumnInfo(Messages.getString("maintenance.type", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		
		tableDefine.add(MaintenanceTableDefine.KEEP_ID,
				new TableColumnInfo(Messages.getString("maintenance.keep", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		
		tableDefine.add(MaintenanceTableDefine.CALENDAR_ID,
				new TableColumnInfo(Messages.getString("calendar.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		
		tableDefine.add(MaintenanceTableDefine.SCHEDULE,
				new TableColumnInfo(Messages.getString("schedule", locale), TableColumnInfo.SCHEDULE, 100, SWT.LEFT));
		
		tableDefine.add(MaintenanceTableDefine.VALID_FLG,
				new TableColumnInfo(Messages.getString("valid", locale) + "/" + Messages.getString("invalid", locale), TableColumnInfo.VALID, 50, SWT.LEFT));
				
		tableDefine.add(MaintenanceTableDefine.CREATE_USER,
				new TableColumnInfo(Messages.getString("creator.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));

		tableDefine.add(MaintenanceTableDefine.CREATE_TIME,
				new TableColumnInfo(Messages.getString("create.time", locale), TableColumnInfo.NONE, 80, SWT.LEFT));

		tableDefine.add(MaintenanceTableDefine.UPDATE_USER,
				new TableColumnInfo(Messages.getString("modifier.name", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		
		tableDefine.add(MaintenanceTableDefine.UPDATE_TIME,
				new TableColumnInfo(Messages.getString("update.time", locale), TableColumnInfo.NONE, 80, SWT.LEFT));
		
		return tableDefine;
    }
}