/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 */
package com.clustercontrol.performance.composite.tree;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.clustercontrol.performance.monitor.ejb.entity.CollectorDeviceInfoData;
import com.clustercontrol.performance.util.code.CollectorItemTreeItem;

/**
 * 収集項目ツリー用のコンテンツプロバイダクラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class CollectorTreeContentProvider implements ITreeContentProvider {
	
	// ----- instance メソッド ----- //
	
	private static final Comparator COMPARATOR = 
		new Comparator() {
		public int compare(Object o1, Object o2) {
			String id1 = ((CollectorItemTreeItem)o1).getCode();
			String id2 = ((CollectorItemTreeItem)o2).getCode();
			
			int comp = id1.compareTo(id2);
			
			if(comp == 0){ // コードが同じ場合はデバイスのインデックス順にソートする
				CollectorDeviceInfoData dv1 = ((CollectorItemTreeItem)o1).getDeviceData();
				CollectorDeviceInfoData dv2 = ((CollectorItemTreeItem)o2).getDeviceData();
				if(dv1 != null && dv2 != null){
					return dv1.getDisplayName().compareTo(dv2.getDisplayName());
//					return ((Long)(dv1.getIndex() - dv2.getIndex())).intValue();
				} else {
					return 0; // どちらかがデバイス情報を保持していない場合
				}
			} else {				
				return id1.compareTo(id2);
			}
		}
	};
	
	/**
	 * 親の要素を取得します。
	 */
	public Object getParent(Object element) {
		return ((CollectorItemTreeItem) element).getParent();
	}
	
	/**
	 * 親の要素を取得します。
	 */
	public Object[] getElements(Object inputElement) {
		return (CollectorItemTreeItem[])inputElement;
	}
	
	/**
	 * 子の要素を取得します。
	 */
	public Object[] getChildren(Object parentElement) {
		List list = ((CollectorItemTreeItem) parentElement).getChildren();
		
		CollectorItemTreeItem[] items =
			(CollectorItemTreeItem[])list.toArray(new CollectorItemTreeItem[list.size()]);
		
		if (items != null) {
			Arrays.sort(items, COMPARATOR);
		}
		
		return items;
	}
	
	/**
	 * 子の要素が存在するか否かをチェックします。
	 */
	public boolean hasChildren(Object element) {
		return ((CollectorItemTreeItem)element).size() > 0;
	}
	
	/**
     * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer,
     *      java.lang.Object, java.lang.Object) 
	 */
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	}
	
	/**
     * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	public void dispose() {
	}
}
