/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.monitor.composite;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;

import com.clustercontrol.monitor.run.composite.MonitorBasicScopeComposite;

/**
 * 監視の基本設定を設定するコンポジットクラス
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class PerfMonitorBasicScopeComposite extends MonitorBasicScopeComposite {

	CollectorItemComboComposite itemCombo;
	
	public PerfMonitorBasicScopeComposite(Composite parent, int style) {
		super(parent, style);
		
        this.initialize();
    }
    
    /**
     * コンポジットを生成・構築します。
     */
    private void initialize() {
        m_buttonScope.addSelectionListener(new SelectionAdapter() {
            @Override
			public void widgetSelected(SelectionEvent e) {
            	itemCombo.setCollectorItemCombo(m_facilityId);
            }
        });
	}
    
    /**
     * 収集項目設定用コンボボックスコンポジットを設定します。
     * @param composite
     */
    public void setCollectorItemComboComposite(CollectorItemComboComposite composite){
    	this.itemCombo = composite;
    }
}
